/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidator;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ColumnTypeCastValidatorFactory
extends ColumnValidatorFactory {
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private static final OperationId OPERATION_ID = new OperationId(5002L);
    public static final DataTypeParameter TARGET_TYPE_PARAMETER = new DataTypeParameter("targetDataType", "Target type", "The data type on which the cast should be checked", Cardinality.ONE);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory evalutorFactory;

    @Inject
    public ColumnTypeCastValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evalutorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evalutorFactory = evalutorFactory;
    }

    public ValidationWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new ColumnTypeCastValidator(invocation, this.cubeManager, this.connectionProvider, this.evalutorFactory);
    }

    protected String getOperationName() {
        return "Column type cast check";
    }

    protected String getOperationDescription() {
        return "Check if a column type can be casted to another one";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Column targetCol = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        DataType dataType = (DataType)OperationHelper.getParameter((LeafParameter)TARGET_TYPE_PARAMETER, (OperationInvocation)invocation);
        return String.format("Check if %s can be converted to %s", OperationHelper.retrieveColumnLabel((Column)targetCol), dataType.getName());
    }

    static {
        parameters.add((Parameter)TARGET_TYPE_PARAMETER);
    }
}

