/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTypeCastValidator
extends ValidationWorker {
    private static final Logger log = LoggerFactory.getLogger(ColumnTypeCastValidator.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private DataType targetType;
    private Column validationColumn;

    public ColumnTypeCastValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = sqlFactory;
    }

    protected ValidityResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Configuring validation");
        this.addValidationColumnToTable();
        this.updateProgress(0.4f, "Validating rows");
        this.fillNewTableWithData();
        this.updateProgress(0.8f, "Evaluating result");
        return new ValidityResult(this.createUpdatedTableMeta() == 0);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        this.targetType = (DataType)OperationHelper.getParameter((LeafParameter)ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER, (OperationInvocation)this.getSourceInvocation());
    }

    private void addValidationColumnToTable() {
        this.createValidationColumn();
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        ValidationReferencesMetadata referenceMeta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{referenceMeta}).create();
    }

    private void createValidationColumn() {
        String columnLabel = OperationHelper.retrieveColumnLabel((Column)this.targetColumn);
        DataValidationMetadata validationMeta = this.createDataValidationMetadata(0);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText(String.format("Is %s a valid %s?", columnLabel, this.targetType.getName())), validationMeta);
    }

    private DataValidationMetadata createDataValidationMetadata(int count) {
        String columnLabel = OperationHelper.retrieveColumnLabel((Column)this.targetColumn);
        ImmutableLocalizedText validationText = new ImmutableLocalizedText(String.format("Tells whether %s can be casted to a %s value", columnLabel, this.targetType.getName()));
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)validationText, count);
        return validationMeta;
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateFillTableSQL();
        try {
            SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to evaluate validation result", (Throwable)e);
        }
    }

    private String generateFillTableSQL() {
        TypeTransitionSQLHandler typeTransitionHandler = TypeTransitionSQLHandler.getHandler(this.targetColumn.getDataType(), this.targetType);
        log.debug("Using Type transition handler: " + typeTransitionHandler.getClass().getSimpleName());
        return typeTransitionHandler.getFillValidationColumnSQLCommand(this.targetTable, this.validationColumn, this.targetColumn);
    }

    private int createUpdatedTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.evaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(invalidCount)}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }
}

