/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;

@Singleton
public class QuarterHelper
implements PeriodTypeHelper {
    @Inject
    CubeManager cubeManager;

    @Override
    public String getFillValidationColumnSQL(String validationTableName, String validationColumnName, String targetColumnName) {
        return String.format("UPDATE %s SET %s = false WHERE %s IS NULL OR NOT(is_valid_quarter(%s))", validationTableName, validationColumnName, targetColumnName, targetColumnName);
    }

    @Override
    public PeriodType getManagedPeriodType() {
        return PeriodType.QUARTER;
    }

    @Override
    public Table createTimeCodelist() {
        return this.cubeManager.createTimeCodelist(PeriodType.QUARTER);
    }

    @Override
    public String getColumnName() {
        return "quarter_code";
    }

    @Override
    public String getFillTimeCodelistSQL(String targetTableName, String targetColumnName, String timeTableName) {
        return String.format("INSERT INTO %s ( quarter_code ) SELECT DISTINCT(normalize_quarter(%s)) FROM %s;", timeTableName, targetColumnName, targetTableName);
    }

    @Override
    public String getUpdateDimensionColumnSQL(String targetColumnName, String newTableName, String timeDimensionColumnName, String timeTableName) {
        return String.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id, quarter_code as val FROM %3$s) as refCol WHERE refCol.val=normalize_quarter(new_table.%4$s) ;", newTableName, timeDimensionColumnName, timeTableName, targetColumnName);
    }
}

