/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidator;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class DuplicateRowValidatorFactory
extends TableValidatorFactory {
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private static final OperationId OPERATION_ID = new OperationId(5003L);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    public static TargetColumnParameter KEY;
    public static MultivaluedStringParameter INVALIDATE_MODE;

    @Inject
    public DuplicateRowValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory factory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = factory;
    }

    public ValidationWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new DuplicateRowValidator(invocation, this.cubeManager, this.connectionProvider, this.evaluatorFactory);
    }

    protected String getOperationName() {
        return "Duplicate tuple validation";
    }

    protected String getOperationDescription() {
        return "Check for duplicate tuples in table";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Object obj = invocation.getParameterInstances().get(KEY.getIdentifier());
        if (obj instanceof Iterable) {
            ArrayList<Column> toCheckColumns = new ArrayList<Column>();
            for (ColumnReference ref : (Iterable)obj) {
                toCheckColumns.add(this.cubeManager.getTable(ref.getTableId()).getColumnById(ref.getColumnId()));
            }
            return String.format("Check if %s form a uniqe column set", OperationHelper.getColumnLabelsSnippet(toCheckColumns));
        }
        ColumnReference ref = (ColumnReference)obj;
        Column col = this.cubeManager.getTable(ref.getTableId()).getColumnById(ref.getColumnId());
        return String.format("Check if %s is unique", OperationHelper.retrieveColumnLabel((Column)col));
    }

    static {
        ArrayList<Object> allowedTableTypes = new ArrayList<Object>();
        ArrayList<Object> allowedColumnTypes = new ArrayList<Object>();
        allowedTableTypes.add(new CodelistTableType());
        allowedTableTypes.add(new GenericTableType());
        allowedTableTypes.add(new DatasetTableType());
        allowedTableTypes.add(new HierarchicalCodelistTableType());
        allowedTableTypes.add(new TimeCodelistTableType());
        allowedColumnTypes.add(new AnnotationColumnType());
        allowedColumnTypes.add(new AttributeColumnType());
        allowedColumnTypes.add(new CodeColumnType());
        allowedColumnTypes.add(new CodeDescriptionColumnType());
        allowedColumnTypes.add(new CodeNameColumnType());
        allowedColumnTypes.add(new DimensionColumnType());
        allowedColumnTypes.add(new MeasureColumnType());
        allowedColumnTypes.add(new TimeDimensionColumnType());
        KEY = new TargetColumnParameter("key", "Key", "To check uniqueness column", new Cardinality(0, Integer.MAX_VALUE), allowedTableTypes, allowedColumnTypes);
        INVALIDATE_MODE = new MultivaluedStringParameter("invalidatemode", "Invalidate mode", "describe the type of key to invalidate", Cardinality.OPTIONAL, Arrays.asList("Older", "Newer"));
        parameters.add((Parameter)KEY);
    }
}

