/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateAmbiguousReferenceFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAmbiguousReference
extends ValidationWorker {
    private static Logger logger = LoggerFactory.getLogger(ValidateAmbiguousReference.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;
    private Table externalTable;
    private Column externalColumn;
    private Map<TDTypeValue, Long> mapping;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private static Logger log = LoggerFactory.getLogger(ValidateAmbiguousReference.class);
    private static final String validationText = "Ambiguous values on external reference validation";
    private ValidationDescriptor validationDescriptor;

    public ValidateAmbiguousReference(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected ValidityResult execute() throws WorkerException, OperationAbortedException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Creating validation structure");
        this.checkAborted();
        this.addValidationColumn();
        this.updateProgress(0.4f, "Filling validation column");
        this.checkAborted();
        this.fillValidationColumn();
        this.updateProgress(0.7f, "Finalizing validation");
        this.checkAborted();
        return new ValidityResult(this.evaluateValidityAndUpdateTableMeta() == 0, Collections.singletonList(this.validationDescriptor));
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        log.debug("targetColumn is " + this.targetColumn);
        this.mapping = (Map)this.getSourceInvocation().getParameterInstances().get(ValidateAmbiguousReferenceFactory.MAPPING_PARAMETER.getIdentifier());
        ColumnReference externalReference = (ColumnReference)this.getSourceInvocation().getParameterInstances().get(ValidateAmbiguousReferenceFactory.TARGET_COLUMN_PARAMETER.getIdentifier());
        this.externalTable = this.cubeManager.getTable(externalReference.getTableId());
        this.externalColumn = this.externalTable.getColumnById(externalReference.getColumnId());
    }

    private int evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.sqlEvaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            this.validationDescriptor = new ValidationDescriptor(invalidCount == 0, validationText, 103, this.validationColumn.getLocalId());
            DataValidationMetadata validationMeta = new DataValidationMetadata(new Validation(validationText, invalidCount == 0, 103), invalidCount);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMeta}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private void fillValidationColumn() throws WorkerException {
        try {
            SQLHelper.executeSQLCommand((String)this.generateValidationSqlCommand(), (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            logger.error("error filling validation column", (Throwable)e.getNextException());
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e.getNextException());
        }
    }

    private String generateValidationSqlCommand() throws WorkerException {
        try {
            StringBuffer mappingFrom = new StringBuffer();
            String mappingWhere = "";
            if (this.mapping != null && !this.mapping.isEmpty()) {
                mappingFrom.append("(VALUES");
                for (Map.Entry<TDTypeValue, Long> mapEntry : this.mapping.entrySet()) {
                    mappingFrom.append(" (").append((String)this.sqlEvaluatorFactory.getEvaluator((Expression)mapEntry.getKey()).evaluate()).append(",").append(mapEntry.getValue()).append("),");
                }
                mappingFrom.deleteCharAt(mappingFrom.lastIndexOf(","));
                mappingFrom.append(") AS mapping (key, value) ");
                mappingWhere = String.format(" AND ( NOT EXISTS ( SELECT NULL FROM %1$s WHERE mapping.key = %2$s.%3$s AND ARRAY[mapping.value] <@ (reference.ids) ) ) ", mappingFrom, this.targetTable.getName(), this.targetColumn.getName());
            }
            String targetColumnSQL = this.targetColumn.getName();
            String externalColumnSQL = this.externalColumn.getName();
            if (!this.targetColumn.getDataType().equals(this.externalColumn.getDataType())) {
                targetColumnSQL = String.valueOf(this.targetColumn.getName()) + "::text";
                externalColumnSQL = String.valueOf(this.externalColumn.getName()) + "::text";
            }
            String query = String.format("UPDATE %1$s SET %2$s = false FROM (SELECT %3$s as value , array_agg(id) AS ids,  count(*) AS count FROM %4$s GROUP BY %3$s) AS reference WHERE  (reference.value = %5$s AND (count>1  %6$s )) ", this.targetTable.getName(), this.validationColumn.getName(), externalColumnSQL, this.externalTable.getName(), targetColumnSQL, mappingWhere);
            return query;
        }
        catch (Exception e) {
            log.error("error updating validation column", (Throwable)e);
            throw new WorkerException("error updating validation column", (Throwable)e);
        }
    }

    private void addValidationColumn() throws WorkerException {
        DataValidationMetadata validationMeta = new DataValidationMetadata(new Validation(validationText, true, 103), 0);
        this.validationColumn = new ValidationColumnFactory().useDefaultValue((TDTypeValue)new TDBoolean(true)).create((LocalizedText)new ImmutableLocalizedText("Ambiguous values"), validationMeta);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        log.debug("Added validation column:\n" + this.targetTable);
        ValidationReferencesMetadata meta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{meta}).create();
    }
}

