/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataset;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class ValidateDatasetFactory
extends TableValidatorFactory {
    private static final OperationId OPERATION_ID = new OperationId(5012L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    @Inject
    private CubeManager cubeManager;

    public ValidationWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        return new ValidateDataset(arg0, this.cubeManager);
    }

    protected String getOperationDescription() {
        return "Check if the table is a valid dataset";
    }

    protected String getOperationName() {
        return "Validate Dataset";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        return String.format("Check if %s is a valid dataset.", OperationHelper.retrieveTableLabel((Table)targetTable));
    }
}

