/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table.metadata;

import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.table.metadata.ChangeColumnPositionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeColumnPositionWorker
extends MetadataWorker {
    private static final Logger log = LoggerFactory.getLogger(ChangeColumnPositionWorker.class);
    private CubeManager cubeManager;

    public ChangeColumnPositionWorker(CubeManager cubeManager, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
    }

    protected EmptyType execute() throws WorkerException {
        List order = (List)this.getSourceInvocation().getParameterInstances().get(ChangeColumnPositionFactory.COLUMN_ORDER.getIdentifier());
        Table table = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        Table viewTable = null;
        List viewCols = null;
        if (table.contains(DatasetViewTableMetadata.class)) {
            viewTable = this.cubeManager.getTable(((DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class)).getTargetDatasetViewTableId());
            viewCols = viewTable.getColumns();
        }
        int offset = 1;
        int i = 0;
        while (i < order.size()) {
            Column toMove = table.getColumnById(((ColumnReference)order.get(i)).getColumnId());
            table = this.cubeManager.exchangeColumnPosition(table.getId(), toMove.getLocalId(), i + 1);
            if (viewTable != null) {
                viewTable = this.cubeManager.exchangeColumnPosition(viewTable.getId(), toMove.getLocalId(), i + offset);
                if (toMove.hasRelationship()) {
                    for (Column col : viewCols) {
                        try {
                            if (!((ViewColumnMetadata)col.getMetadata(ViewColumnMetadata.class)).getSourceTableDimensionColumnId().equals((Object)toMove.getLocalId())) continue;
                            viewTable = this.cubeManager.exchangeColumnPosition(viewTable.getId(), col.getLocalId(), i + ++offset);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        log.debug("Result table : " + table);
        if (viewTable != null) {
            log.debug("Result view : " + viewTable);
        }
        return EmptyType.instance();
    }
}

