/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.Collections;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateValuesInColumnValidator
extends ValidationWorker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateValuesInColumnValidator.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;

    public DuplicateValuesInColumnValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory factory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = factory;
    }

    protected ValidityResult execute() throws WorkerException, OperationAbortedException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Configuring validationg");
        this.checkAborted();
        this.createNewTableWithValidationColumn();
        this.updateProgress(0.5f, "Validating rows");
        this.checkAborted();
        this.fillNewTableWithData();
        this.updateProgress(0.8f, "Evaluating result");
        this.checkAborted();
        int invalidCount = this.evaluateValidityAndUpdateTableMeta();
        return new ValidityResult(invalidCount == 0, Collections.singletonList(this.createValidationColumn(invalidCount, this.validationColumn)));
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
    }

    private void createNewTableWithValidationColumn() {
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(0);
        this.validationColumn = new ValidationColumnFactory().useDefaultValue((TDTypeValue)new TDBoolean(true)).create((LocalizedText)new ImmutableLocalizedText("Unique " + OperationHelper.retrieveColumnLabel((Column)this.targetColumn)), dataValidationMetadata);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        ValidationReferencesMetadata refreferenceMeta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{refreferenceMeta}).create();
    }

    private DataValidationMetadata createDataValidationMetadata(int count) {
        String validationDescription = "True when the value in column " + OperationHelper.retrieveColumnLabel((Column)this.targetColumn) + " is not a duplicate, false otherwise";
        return new DataValidationMetadata(new Validation(validationDescription, count == 0, 102), count);
    }

    private ValidationDescriptor createValidationColumn(int count, Column validationColumn) {
        String validationDescription = "No values in column " + OperationHelper.retrieveColumnLabel((Column)this.targetColumn) + " are duplicates";
        return new ValidationDescriptor(count == 0, validationDescription, 102, validationColumn.getLocalId());
    }

    private void fillNewTableWithData() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.createSetFalseOnDuplicatesSQL()});
        }
        catch (Exception e) {
            String msg = "Unable to perform SQL operation";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
    }

    private String createSetFalseOnDuplicatesSQL() {
        return String.format("UPDATE %2$s AS target SET %3$s=false WHERE   id NOT IN (SELECT distinct min(id) from %2$s GROUP BY %1$s) ", this.targetColumn.getName(), this.targetTable.getName(), this.validationColumn.getName());
    }

    private int evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.evaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(invalidCount)}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }
}

