/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ImportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.SDMXCodelistImporter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class SDMXCodelistImporterFactory
extends ImportWorkerFactory {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private static OperationDescriptor.OperationId operationId = new OperationDescriptor.OperationId(200L);
    private static List<Parameter> parameters = new ArrayList<Parameter>();

    static {
        SDMXCodelistImporterFactory.createParameters();
    }

    @Inject
    public SDMXCodelistImporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        if (cubeManager == null) {
            throw new IllegalArgumentException("cubeManager cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider cannot be null");
        }
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    private static void createParameters() {
        parameters.add((Parameter)new RegexpStringParameter("registryBaseUrl", "Registry Base URL", "URL that points to the registry REST base endpoint", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX Codelist id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Codelist version", Cardinality.ONE, "[0-9]+\\.[0-9]+"));
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        WorkerUtils.checkParameters(parameters, invocation);
        return new SDMXCodelistImporter(this.cubeManager, this.connectionProvider, invocation);
    }

    protected String getOperationName() {
        return "SDMX Codelist import";
    }

    protected String getOperationDescription() {
        return "Import a codelist from a SDMX registry";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return operationId;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }
}

