/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types;

import java.util.Properties;
import org.gcube.data.analysis.excel.data.Column;
import org.gcube.data.analysis.excel.data.GenericColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFactory {
    private Properties dataTypes;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static ColumnFactory instance;

    private ColumnFactory() {
        this.dataTypes = new Properties();
        this.dataTypes.getClass().getResourceAsStream("/datatypes.properties");
    }

    public static ColumnFactory getInstance() {
        if (instance == null) {
            instance = new ColumnFactory();
        }
        return instance;
    }

    public Column createColumn(String columnName, String dataTypeName) {
        this.logger.debug("Data Type = " + dataTypeName);
        String columnTypeName = this.dataTypes.getProperty(dataTypeName);
        GenericColumn response = null;
        if (columnName == null) {
            this.logger.debug("Data type not found: using generic instance");
            response = new GenericColumn(columnName);
        } else {
            this.logger.debug("Data type found " + columnTypeName);
            try {
                Class<?> className = Class.forName(columnTypeName);
                response = (Column)className.getConstructor(String.class).newInstance(columnName);
            }
            catch (Exception e) {
                this.logger.error("Class " + columnName + " not found, using generic type", (Throwable)e);
                response = new GenericColumn(columnName);
            }
        }
        return response;
    }
}

