/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.analtsis.excel.engine.exceptions.ExcelNotSavedException;
import org.gcube.data.analtsis.excel.engine.impl.WorkspaceExcelGenerator;
import org.gcube.data.analysis.excel.data.TableMetaData;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ExcelGeneratorAbstractImpl
implements ExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableMetaData tableMetadata;

    protected void setTable(TableMetaData tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    @Override
    public void generateExcel(String fileName, String folderName) {
        this.logger.debug("Generating sample excel on the workspace");
        String securityToken = SecurityTokenProvider.instance.get();
        if (securityToken == null) {
            this.logger.error("Token not found");
        } else {
            this.logger.debug("Token retrieved");
            this.logger.debug("Saving file " + fileName + " in the folder " + folderName);
            WorkspaceExcelGenerator excelGenerator = new WorkspaceExcelGenerator(this.tableMetadata, securityToken, fileName, folderName);
            this.logger.debug("Generating file..");
            excelGenerator.generate();
            this.logger.debug("File generated");
            try {
                this.logger.debug("Saving file..");
                excelGenerator.save();
                this.logger.debug("File saved");
            }
            catch (ExcelNotSavedException e) {
                this.logger.warn("Excel file not saved", (Throwable)e);
            }
        }
    }
}

