/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.VoidExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.template.SDMXTemplateExporter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDMXTemplateExporterFactory
extends VoidExportWorkerFactory {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final OperationId operationId = new OperationId(204L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    @Inject
    public SDMXTemplateExporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    private void checkTargetTemplateEligibility(Map<String, Template> templateMap, OperationInvocation invocation) throws InvalidInvocationException {
        this.logger.debug("Checking template eligibility...");
        if (templateMap == null || templateMap.get("template") == null) {
            throw new InvalidInvocationException(invocation, "Template not found");
        }
        Template template = templateMap.get("template");
        List templateColumns = template.getActualStructure();
        int measure = 0;
        int timeDimension = 0;
        Iterator templateColumnsIterator = templateColumns.iterator();
        while (templateColumnsIterator.hasNext() && (measure == 0 || timeDimension == 0)) {
            TemplateColumn templateColumn = (TemplateColumn)templateColumnsIterator.next();
            this.logger.debug("Column category " + templateColumn.getColumnType());
            if (templateColumn.getColumnType() == ColumnCategory.MEASURE) {
                measure = 1;
                continue;
            }
            if (templateColumn.getColumnType() != ColumnCategory.TIMEDIMENSION) continue;
            timeDimension = 2;
        }
        switch (measure + timeDimension) {
            case 0: {
                this.logger.debug("Missing timeset and measure");
                throw new InvalidInvocationException(invocation, "Missing timeset and measure");
            }
            case 1: {
                this.logger.debug("Missing timeset");
                throw new InvalidInvocationException(invocation, "Missing timeset");
            }
            case 2: {
                this.logger.debug("Missing measure");
                throw new InvalidInvocationException(invocation, "Missing measure");
            }
        }
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.logger.debug("Creating worker");
        Map templateMap = (Map)invocation.getParameterInstances().get("template");
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkTargetTemplateEligibility(templateMap, invocation);
        return new SDMXTemplateExporter((Template)templateMap.get("template"), this.connectionProvider, invocation, this.cubeManager);
    }

    protected String getOperationName() {
        return "Export a Template to SDMX registry";
    }

    protected String getOperationDescription() {
        return "Retrieve the metadata of the Templateand exports them to the remote SDMX registry";
    }

    protected OperationId getOperationId() {
        return operationId;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    static {
        parameters.add((Parameter)new RegexpStringParameter("registryBaseUrl", "Registry REST URL", "Target SDMX Registry REST Service base URL", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX DSD id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Data set version", Cardinality.ONE, "[0-9]+(\\.[0-9]+)?"));
        parameters.add((Parameter)new RegexpStringParameter("obsValueColumn", "Observation Value", "Observation Value column", Cardinality.ONE, "[0-9a-z-]+"));
        parameters.add((Parameter)new MapParameter("template", "Template", "Template", Cardinality.ONE, String.class, Template.class));
        parameters.add((Parameter)new BooleanParameter("excel", "Excel Document", "Excel document requested", Cardinality.OPTIONAL));
    }
}

