/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.codelist;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.security.Credentials;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistExporter
extends ResourceCreatorWorker {
    private static Logger log = LoggerFactory.getLogger(SDMXCodelistExporter.class);
    private Table table;
    private OperationInvocation invocation;
    private DatabaseConnectionProvider connectionProvider;
    private String targetUrl;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private String username;
    private String password;
    private static String errorMessage = "Unable to complete export procedure";

    public SDMXCodelistExporter(Table table, OperationInvocation invocation, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.username = null;
        this.password = null;
    }

    protected ResourcesResult execute() throws WorkerException {
        try {
            this.retrieveParameters();
            SDMXCodelistGenerator codelistGenerator = new SDMXCodelistGenerator(this.table, this.connectionProvider, this.targetAgency, this.targetId, this.targetVersion);
            this.updateProgress(0.1f, "Creating beans");
            CodelistMutableBean codelist = codelistGenerator.createBaseCodelistBean();
            this.updateProgress(0.2f, "Populating codelist");
            codelistGenerator.populateCodelistWithCodes(codelist);
            this.updateProgress(0.6f, "Publishing");
            this.publishCodelist(codelist);
            this.updateProgress(0.8f, "Finalizing");
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(this.targetUrl)), "Codelist SDMX export", String.format("%scodelist/%s/%s/%s/", this.targetUrl, this.targetAgency, this.targetId, this.targetVersion), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (SQLException e) {
            log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new WorkerException(String.format("exported url %s not valid", this.targetUrl), (Throwable)e);
        }
    }

    private void retrieveParameters() {
        this.targetUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetAgency = (String)this.invocation.getParameterInstances().get("agency");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        this.targetVersion = (String)this.invocation.getParameterInstances().get("version");
        Credentials credentials = WorkerUtils.retrieveCredentials(this.targetUrl);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    private void publishCodelist(CodelistMutableBean codelist) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        log.debug("Publishing data in " + url);
        SDMXRegistryClient registryClient = WorkerUtils.initSDMXClient(url, this.username, this.password);
        log.debug("SDMX client intialized");
        try {
            log.debug("Generating immutable instance");
            CodelistBean codeList = codelist.getImmutableInstance();
            log.debug("Immutable instance generated");
            registryClient.publish(codeList);
            log.debug("Codelist publised");
        }
        catch (SDMXRegistryClientException e) {
            throw new WorkerException("Unable to publish codelist on registry.", (Throwable)e);
        }
    }
}

