package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import java.util.List;

import org.gcube.data.analysis.excel.data.Column;
import org.gcube.data.analysis.excel.data.TableMetaData;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.ColumnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelGeneratorFromTable extends ExcelGeneratorAbstractImpl implements ExcelGenerator {

	private Logger logger;
	private Table table;
	
	
	public ExcelGeneratorFromTable(Table table) {
		super ();
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.table = table;
		
	}

	private TableMetaData generateTableMetadata ()
	{
		logger.debug("Generating template columns");
		List<org.gcube.data.analysis.tabulardata.model.column.Column> columns = this.table.getColumns();
		this.logger.debug("Table name "+this.table.getName());
		TableMetaData tableMetadata = new TableMetaData (this.table.getName());
		
		for (org.gcube.data.analysis.tabulardata.model.column.Column column : columns)
		{
	
			String columnName = column.getName();
			
			logger.debug("Adding column "+columnName);
			Column metadataColumn = ColumnFactory.getInstance().createColumn(columnName, column.getColumnType().getClass().getName());
			tableMetadata.addColumn(metadataColumn);
			logger.debug("Column added");
		}
		
		return tableMetadata;
	}
	
	@Override
	public void generateExcel(String fileName, String folderName) {

		this.logger.debug("Generating exel file "+fileName+ " in the folder "+folderName);
		super.setTable(this.generateTableMetadata());
		this.logger.debug("Metadata table generated");
		super.generateExcel(fileName, folderName);
	}
	

}
