/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.conceptscheme;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXConceptSchemeGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Table table;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private List<LocalizedText> tableNamesMetadata;

    public SDMXConceptSchemeGenerator(Table table, String targetId, String targetAgency, String targetVersion) {
        this.table = table;
        this.targetAgency = targetAgency;
        this.targetVersion = targetVersion;
        this.targetId = targetId;
    }

    public void populateConceptsScheme(ConceptSchemeMutableBean conceptScheme) throws WorkerException {
        this.log.debug("Loading columns");
        List columns = this.table.getColumnsByType(new Class[]{MeasureColumnType.class});
        columns.addAll(this.table.getColumnsByType(new Class[]{DimensionColumnType.class}));
        columns.addAll(this.table.getColumnsByType(new Class[]{AttributeColumnType.class}));
        columns.addAll(this.table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}));
        this.log.debug("Columns loaded");
        for (Column column : columns) {
            this.log.debug("Generating concept for column " + column.getName());
            ConceptMutableBean columnConcept = this.createConceptBean(column);
            conceptScheme.addItem((ItemMutableBean)columnConcept);
            this.log.debug("Concept generated");
        }
    }

    public ConceptMutableBean createConceptBean(Column column) {
        this.log.debug("Generating concept mutable bean for column " + column.getName());
        ConceptMutableBeanImpl concept = new ConceptMutableBeanImpl();
        char[] labelChars = column.getName().toCharArray();
        StringBuilder conceptIdBuilder = new StringBuilder();
        char[] cArray = labelChars;
        int n = labelChars.length;
        int n2 = 0;
        while (n2 < n) {
            char labelChar = cArray[n2];
            if (labelChar != ' ') {
                conceptIdBuilder.append(labelChar);
            }
            ++n2;
        }
        concept.setId(String.valueOf(conceptIdBuilder.toString()) + "_concept");
        concept.setParentAgency(this.targetAgency);
        try {
            List conceptNames = ((NamesMetadata)column.getMetadata(NamesMetadata.class)).getTexts();
            this.log.debug("Concept names size " + conceptNames.size());
            concept.setNames(this.getNamesMetadata(conceptNames, null, null));
        }
        catch (NoSuchMetadataException noSuchMetadataException) {
            // empty catch block
        }
        return concept;
    }

    public ConceptSchemeMutableBean createConceptSchemeBean() {
        this.loadMetadata();
        ConceptSchemeMutableBeanImpl conceptScheme = new ConceptSchemeMutableBeanImpl();
        String conceptID = String.valueOf(this.targetId) + "_concepts";
        conceptScheme.setId(conceptID);
        conceptScheme.setAgencyId(this.targetAgency);
        conceptScheme.setVersion(this.targetVersion);
        conceptScheme.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(conceptID) + " Concepts", "en"));
        return conceptScheme;
    }

    private List<TextTypeWrapperMutableBean> getNamesMetadata(List<LocalizedText> metadataValues, String defaultValue, String defaultLocale) {
        ArrayList response = Lists.newArrayList();
        if (metadataValues.size() == 0 && defaultValue != null) {
            this.log.warn("Names Metadata: using default value " + defaultValue);
            response.add(new TextTypeWrapperMutableBeanImpl(defaultLocale, defaultValue));
        } else {
            for (LocalizedText text : metadataValues) {
                this.log.debug("Adding metadata value " + text.getValue() + " " + text.getLocale());
                response.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
        }
        return response;
    }

    private void loadMetadata() {
        try {
            this.tableNamesMetadata = ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts();
        }
        catch (NoSuchMetadataException e) {
            this.tableNamesMetadata = Lists.newArrayList();
        }
    }
}

