package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;

public class DataStructureBean 
{
	private DataStructureMutableBean dsd;
	private ConceptSchemeMutableBean concepts;
	private DataflowMutableBean dataFlow;
	private Map<String,CodelistBean> associatedCodelists;
	
	public DataStructureBean ()
	{
		this.associatedCodelists = new HashMap<>();
	}
	
	
	public DataStructureMutableBean getDsd() {
		return dsd;
	}
	public void setDsd(DataStructureMutableBean dsd) {
		this.dsd = dsd;
	}
	public ConceptSchemeMutableBean getConcepts() {
		return concepts;
	}
	public void setConcepts(ConceptSchemeMutableBean concepts) {
		this.concepts = concepts;
	}
	public DataflowMutableBean getDataFlow() {
		return dataFlow;
	}
	public void setDataFlow(DataflowMutableBean dataFlow) {
		this.dataFlow = dataFlow;
	}
	public Map<String, CodelistBean> getAssociatedCodelists() {
		return associatedCodelists;
	}
	public void addAssociatedCodelist(String columnId, CodelistBean codelist) {
		this.associatedCodelists.put(columnId, codelist);
	}
	
	

	public Set<CodelistBean> getAllCodelists ()
	{
		return new HashSet<>(this.associatedCodelists.values());
	}

}
