/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types;

import java.io.IOException;
import java.util.Properties;
import org.gcube.data.analysis.excel.ColumnModel;
import org.gcube.data.analysis.excel.data.DataColumn;
import org.gcube.data.analysis.excel.data.StringColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.DataColumnBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.TableBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats.DataFormatGeneratorFactory;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats.data.DataFormatGeneratorData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFactoryData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static ColumnFactoryData instance;
    private Properties dataFormats = new Properties();
    private Properties columnTypes = new Properties();
    private String DEFAULT_COLUMN_TYPE = "ATTRIBUTE";

    private ColumnFactoryData() {
        try {
            this.dataFormats.load(this.getClass().getResourceAsStream("/dataformatData.properties"));
        }
        catch (IOException e) {
            this.logger.error("Unable to find dataformat data properties", (Throwable)e);
        }
        try {
            this.columnTypes.load(this.getClass().getResourceAsStream("/columnTypeData.properties"));
        }
        catch (IOException e) {
            this.logger.error("Unable to find dataformat data properties", (Throwable)e);
        }
    }

    public static ColumnFactoryData getInstance() {
        if (instance == null) {
            instance = new ColumnFactoryData();
        }
        return instance;
    }

    public DataColumn createColumn(DataColumnBean columnBean, TableBean tableBean, String locale) {
        Column column = columnBean.getColumn();
        String columnType = column.getColumnType().getCode();
        this.logger.debug("Column type " + columnType);
        String typeDataFormatName = this.dataFormats.getProperty(columnType);
        this.logger.debug("Type data format " + typeDataFormatName);
        DataFormatGeneratorData typeDataFormat = DataFormatGeneratorFactory.getDataFormatGeneratorData(typeDataFormatName);
        StringColumn response = new StringColumn(columnBean.getName(locale), typeDataFormat.getDataFormat(columnBean, locale), this.getColumnType(columnType));
        response.setAllData(columnBean.getData());
        return response;
    }

    private ColumnModel.ColumnType getColumnType(String typeCode) {
        this.logger.debug("Looking for the column type for type code " + typeCode);
        String columnTypeString = this.columnTypes.getProperty(typeCode);
        this.logger.debug("Column type " + columnTypeString);
        if (columnTypeString == null) {
            columnTypeString = this.DEFAULT_COLUMN_TYPE;
        }
        ColumnModel.ColumnType response = Enum.valueOf(ColumnModel.ColumnType.class, columnTypeString);
        this.logger.debug("Column type " + response);
        return response;
    }
}

