/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateBean {
    private Template template;
    private List<TemplateColumn<?>> templateColumns;
    private TemplateColumn<?> primaryMeasure;
    private Map<String, CodelistBean> codelists;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public TemplateBean(Template template) {
        this.template = template;
        this.codelists = new HashMap<String, CodelistBean>();
        this.templateColumns = new ArrayList(template.getActualStructure());
    }

    public Template getTemplate() {
        return this.template;
    }

    public void addCodelist(String column, CodelistBean codelist) {
        this.codelists.put(column, codelist);
    }

    public Map<String, CodelistBean> getCodelists() {
        return this.codelists;
    }

    public void setPrimaryMeasure(String observationValue) {
        this.log.debug("Loading primary measure");
        this.log.debug("For obs value " + observationValue);
        int size = this.templateColumns.size();
        TemplateColumn<?> response = null;
        for (int i = 0; response == null && i < size; ++i) {
            TemplateColumn<?> templateColumn = this.templateColumns.get(i);
            String columnID = templateColumn.getId();
            ColumnCategory columnType = templateColumn.getColumnType();
            this.log.debug("Column label " + templateColumn.getLabel());
            this.log.debug("Column id " + templateColumn.getId());
            this.log.debug("Column type " + columnType);
            if (columnType != ColumnCategory.MEASURE || !columnID.equals(observationValue)) continue;
            this.log.debug("Primary measure found");
            response = this.templateColumns.remove(i);
        }
        this.primaryMeasure = response;
    }

    public List<TemplateColumn<?>> getGenericTemplateColumns() {
        return this.templateColumns;
    }

    public TemplateColumn<?> getPrimaryMeasure() {
        return this.primaryMeasure;
    }
}

