/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.SDMXResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.conceptscheme.SDMXConceptSchemeGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.configuration.ConfigurationManager;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.DataStructureDefinitionWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.DataStructureBean;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableSDMXResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SDMXDataStructureDefinitionAbstractExporter
extends ResourceCreatorWorker {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Table table;
    private OperationInvocation invocation;
    private CubeManager cubeManager;
    private final String ATTRIBUTE_ASSIGNMENT_STATUS_MANDATORY = "Mandatory";
    private static String errorMessage = "Unable to complete export procedure";
    private DatabaseConnectionProvider connectionProvider;
    private SDMXConceptSchemeGenerator conceptSchemeGenerator;
    private final String CODELIST_VERSION_ACTION_PROPERTY = "codelist.version.action";
    private final String CODELIST_VERSION_ACTION_BLOCK = "block";
    private final String CODELIST_VERSION_ACTION_WARNING = "warning";

    public SDMXDataStructureDefinitionAbstractExporter(Table table, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation, CubeManager cubeManager) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
    }

    protected ResourcesResult execute() throws WorkerException {
        this.log.debug("Init parameters and functionalities");
        Parameters parameters = this.getParameters(this.invocation);
        this.conceptSchemeGenerator = new SDMXConceptSchemeGenerator(this.table, parameters.targetId, parameters.targetAgency, parameters.targetVersion);
        List<LocalizedText> tableNamesMetadata = this.loadMetadata();
        this.log.debug("Parameters and functionalities initialized");
        try {
            this.updateProgress(0.1f, "Creating beans");
            DataStructureBean dataStructure = this.createDataStructureBean(this.table, parameters.targetAgency, parameters.targetVersion, parameters.targetId, tableNamesMetadata);
            ConceptSchemeMutableBean conceptScheme = this.conceptSchemeGenerator.createConceptSchemeBean();
            dataStructure.setConcepts(conceptScheme);
            DataflowMutableBean dataFlow = this.createDataFlowBean(dataStructure.getDsd(), tableNamesMetadata, parameters);
            dataStructure.setDataFlow(dataFlow);
            this.updateProgress(0.2f, "Populating data structure");
            this.populateDataStructure(dataStructure, parameters);
            this.updateProgress(0.6f, "Publishing");
            String warning = this.publishData(dataStructure, parameters);
            this.log.warn(warning);
            this.extraOperation(dataStructure);
            this.updateProgress(0.9f, "Finalizing");
            SDMXResource sdmxResource = new SDMXResource(new URL(WorkerUtils.getResourceURI(parameters.registryUrl)), dataStructure.getDsd().getId(), parameters.targetVersion, parameters.targetAgency, SDMXResource.TYPE.DATA_STRUCTURE);
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableSDMXResource(sdmxResource, "Data Structure SDMX export", sdmxResource.toString(), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            this.log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WorkerException(String.format("exported url %s not valid", parameters.registryUrl), (Throwable)e);
        }
    }

    private int checkCodelistVersionAction() {
        String actionParameter = ConfigurationManager.getInstance().getValue("codelist.version.action");
        this.log.debug("Codelist action parameter " + actionParameter);
        if (actionParameter == null || actionParameter.equals("block")) {
            return 2;
        }
        if (actionParameter.equals("warning")) {
            return 1;
        }
        return 0;
    }

    protected abstract void extraOperation(DataStructureBean var1);

    private Parameters getParameters(OperationInvocation invocation) {
        Parameters parameters = new Parameters();
        parameters.registryUrl = (String)invocation.getParameterInstances().get("registryBaseUrl");
        parameters.targetAgency = (String)invocation.getParameterInstances().get("agency");
        parameters.targetId = (String)invocation.getParameterInstances().get("id");
        parameters.targetVersion = (String)invocation.getParameterInstances().get("version");
        parameters.credentials = RegistryInformationProvider.retrieveCredentials((String)parameters.registryUrl);
        String observationValue = (String)invocation.getParameterInstances().get("obsValueColumn");
        parameters.primaryMeasure = this.table.getColumnById(new ColumnLocalId(observationValue));
        return parameters;
    }

    private String publishData(DataStructureBean dataStructure, Parameters parameters) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        SDMXRegistryClient registryClient = DataStructureDefinitionWorkerUtils.initSDMXClient(url, parameters.credentials.getUsername(), parameters.credentials.getPassword());
        String currentType = null;
        String warning = "";
        try {
            this.log.debug("Publishing associated codelists...");
            currentType = "codelists";
            for (CodelistBean codelist : dataStructure.getAllCodelists()) {
                try {
                    this.log.debug("Publishing codelist " + codelist.getId());
                    registryClient.publish(codelist);
                    this.log.debug("Codelist published");
                }
                catch (SDMXVersionException e) {
                    switch (this.checkCodelistVersionAction()) {
                        case 2: {
                            throw e;
                        }
                        case 1: {
                            warning = warning + e.getMessage() + " ";
                        }
                    }
                    this.log.warn(e.getMessage(), (Throwable)e);
                }
            }
            this.log.debug("Codelists published");
            currentType = "concepts";
            this.log.debug("Publishing concepts...");
            registryClient.publish(dataStructure.getConcepts().getImmutableInstance());
            this.log.debug("Concepts published");
            currentType = "data structure definitions";
            this.log.debug("Publishing dsd...");
            registryClient.publish(dataStructure.getDsd().getImmutableInstance());
            this.log.debug("DSD published");
            currentType = "data flow";
            this.log.debug("Publishing data flow...");
            registryClient.publish(dataStructure.getDataFlow().getImmutableInstance());
            this.log.debug("Data flow published");
            this.log.debug("Warning message " + warning);
            return warning;
        }
        catch (SDMXVersionException e) {
            this.log.error("Error in the pubblication", (Throwable)e);
            throw new WorkerException(e.getMessage(), (Throwable)e);
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("Error in the SDMX client", (Throwable)e);
            throw new WorkerException("Unable to publish dsd on registry: error in the" + currentType, (Throwable)e);
        }
    }

    private void populateDataStructure(DataStructureBean dataStructure, Parameters parameters) throws WorkerException {
        ArrayList<Column> columnsList = new ArrayList<Column>();
        columnsList.add(parameters.primaryMeasure);
        this.log.debug("Pupulating data structure");
        ArrayList<Column> measureColumns = new ArrayList<Column>();
        this.getMeasures(measureColumns, parameters);
        columnsList.addAll(measureColumns);
        this.log.debug("Measure columns loaded");
        this.addPrimaryMeasure(dataStructure, parameters);
        this.log.debug("Primary measure added");
        this.addMeasureDimensions(dataStructure, measureColumns, parameters);
        this.log.debug("Measure dimensions added");
        this.log.debug("Adding generic dimension bean");
        List dimensionColumns = this.table.getColumnsByType(new Class[]{DimensionColumnType.class});
        this.addGenericDimensions(dataStructure, dimensionColumns, parameters);
        columnsList.addAll(dimensionColumns);
        this.log.debug("Dimension columns added");
        Column timeDimensionColumn = (Column)this.table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).get(0);
        this.addTimeDimension(dataStructure, timeDimensionColumn, parameters);
        columnsList.add(timeDimensionColumn);
        List attributeColumns = this.table.getColumnsByType(new Class[]{AttributeColumnType.class});
        this.addAttributes(dataStructure, attributeColumns, parameters);
        columnsList.addAll(attributeColumns);
        this.registerData(dataStructure, this.table, columnsList, this.connectionProvider);
    }

    private void addTimeDimension(DataStructureBean dataStructure, Column timeDimensionColumn, Parameters parameters) {
        this.log.debug("Adding time dimension");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        DimensionMutableBeanImpl timeDimensionBean = new DimensionMutableBeanImpl();
        timeDimensionBean.setId("TIME_PERIOD");
        ConceptMutableBean timeDimensionConcept = this.conceptSchemeGenerator.createConceptBean(timeDimensionColumn);
        concepts.addItem((ItemMutableBean)timeDimensionConcept);
        timeDimensionBean.setConceptRef(this.getConceptReference(concepts, timeDimensionConcept, parameters.targetVersion));
        timeDimensionBean.setTimeDimension(true);
        dataStructure.getDsd().addDimension((DimensionMutableBean)timeDimensionBean);
        this.registerTimeDimensionColumn(timeDimensionColumn, timeDimensionConcept, dataStructure);
    }

    protected abstract void registerTimeDimensionColumn(Column var1, ConceptMutableBean var2, DataStructureBean var3);

    private void addGenericDimensions(DataStructureBean dataStructure, List<Column> dimensionColumns, Parameters parameters) {
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : dimensionColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            CodelistBean immutableCodelist = this.createCodeListRepresentation(column, parameters);
            if (immutableCodelist != null) {
                columnConcept.setCoreRepresentation(this.getCoreRepresentation(immutableCodelist));
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept, parameters.targetVersion);
            DimensionMutableBeanImpl dimension = new DimensionMutableBeanImpl();
            dimension.setId(column.getName() + "_DSD");
            dimension.setConceptRef(conceptsReference);
            dataStructure.getDsd().addDimension((DimensionMutableBean)dimension);
            this.registerDimensionColumn(column, columnConcept, immutableCodelist, dataStructure);
        }
    }

    private void addAttributes(DataStructureBean dataStructure, List<Column> attributeColumns, Parameters parameters) {
        this.log.debug("Adding attribute list bean");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : attributeColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            CodelistBean immutableCodelist = this.createCodeListRepresentation(column, parameters);
            if (immutableCodelist != null) {
                columnConcept.setCoreRepresentation(this.getCoreRepresentation(immutableCodelist));
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept, parameters.targetVersion);
            AttributeMutableBeanImpl attributeBean = new AttributeMutableBeanImpl();
            attributeBean.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
            attributeBean.setAssignmentStatus("Mandatory");
            attributeBean.setConceptRef(conceptsReference);
            dataStructure.getDsd().addAttribute((AttributeMutableBean)attributeBean);
            this.registerAttributeColumn(column, columnConcept, immutableCodelist, dataStructure);
        }
    }

    protected abstract void registerDimensionColumn(Column var1, ConceptMutableBean var2, CodelistBean var3, DataStructureBean var4);

    protected abstract void registerAttributeColumn(Column var1, ConceptMutableBean var2, CodelistBean var3, DataStructureBean var4);

    private RepresentationMutableBean getCoreRepresentation(CodelistBean immutableCodelist) {
        RepresentationMutableBeanImpl coreRepresentation = new RepresentationMutableBeanImpl();
        coreRepresentation.setRepresentation((StructureReferenceBean)new StructureReferenceBeanImpl((IdentifiableBean)immutableCodelist));
        this.log.debug("Found a code list representation");
        return coreRepresentation;
    }

    private void getMeasures(List<Column> measures, Parameters parameters) {
        this.log.debug("Loading measures");
        measures.addAll(this.table.getColumnsByType(new Class[]{MeasureColumnType.class}));
        measures.remove(parameters.primaryMeasure);
    }

    private void addPrimaryMeasure(DataStructureBean dataStructure, Parameters parameters) {
        ConceptMutableBean primaryMeasureConcept = this.conceptSchemeGenerator.createConceptBean(parameters.primaryMeasure);
        dataStructure.getConcepts().addItem((ItemMutableBean)primaryMeasureConcept);
        StructureReferenceBeanImpl conceptReferenceBean = new StructureReferenceBeanImpl(primaryMeasureConcept.getParentAgency(), dataStructure.getConcepts().getId(), parameters.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{primaryMeasureConcept.getId()});
        PrimaryMeasureMutableBeanImpl primaryMeasureBean = new PrimaryMeasureMutableBeanImpl();
        primaryMeasureBean.setConceptRef((StructureReferenceBean)conceptReferenceBean);
        primaryMeasureBean.setId("OBS_VALUE");
        dataStructure.getDsd().setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasureBean);
        this.registerPrimaryMeasure(parameters.primaryMeasure, primaryMeasureConcept, dataStructure);
        this.log.debug("Primary measure added");
    }

    private void addMeasureDimensions(DataStructureBean dataStructure, List<Column> measures, Parameters parameters) {
        this.log.debug("Adding measure dimension list bean");
        ConceptSchemeMutableBean concepts = dataStructure.getConcepts();
        for (Column column : measures) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            dimensionBean.setMeasureDimension(true);
            dimensionBean.setConceptRef(this.getConceptReference(concepts, columnConcept, parameters.targetVersion));
            dataStructure.getDsd().addDimension((DimensionMutableBean)dimensionBean);
            this.registerMeasureColumn(column, columnConcept, dataStructure);
        }
    }

    protected abstract void registerPrimaryMeasure(Column var1, ConceptMutableBean var2, DataStructureBean var3);

    protected abstract void registerMeasureColumn(Column var1, ConceptMutableBean var2, DataStructureBean var3);

    private StructureReferenceBean getConceptReference(ConceptSchemeMutableBean conceptScheme, ConceptMutableBean concept, String conceptVersion) {
        this.log.debug("Creating reference for concept " + concept.getId());
        return new StructureReferenceBeanImpl(concept.getParentAgency(), conceptScheme.getId(), conceptVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{concept.getId()});
    }

    private CodelistBean createCodeListRepresentation(Column column, Parameters parameters) {
        this.log.debug("Creating codelist bean");
        CodelistBean response = null;
        Table codelist = this.getAssociatedCodelist(column);
        if (codelist != null) {
            this.log.debug("Table found " + codelist.getName());
            SDMXCodelistGenerator codeListGenerator = new SDMXCodelistGenerator(codelist, this.connectionProvider, parameters.targetAgency, codelist.getName() + "_CL", parameters.targetVersion);
            CodelistMutableBean codeListBean = codeListGenerator.createBaseCodelistBean();
            try {
                codeListGenerator.populateCodelistWithCodes(codeListBean);
                response = codeListBean.getImmutableInstance();
            }
            catch (Exception e) {
                this.log.warn("Codelist not loaded", (Throwable)e);
            }
        }
        return response;
    }

    protected abstract DataStructureBean createDataStructureBean(Table var1, String var2, String var3, String var4, List<LocalizedText> var5);

    private DataflowMutableBean createDataFlowBean(DataStructureMutableBean dataStructure, List<LocalizedText> tableNamesMetadata, Parameters parameters) {
        DataflowMutableBeanImpl dataFlow = new DataflowMutableBeanImpl();
        this.log.debug("Populating data flow bean");
        dataFlow.setAgencyId(parameters.targetAgency);
        dataFlow.setDataStructureRef((StructureReferenceBean)new StructureReferenceBeanImpl(dataStructure.getAgencyId(), dataStructure.getId(), parameters.targetVersion, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
        dataFlow.setId(parameters.targetId + "_dataFlow");
        dataFlow.setVersion(parameters.targetVersion);
        dataFlow.setNames(this.getNamesMetadata(tableNamesMetadata, parameters.targetId + " Data Flow", "en"));
        return dataFlow;
    }

    private List<LocalizedText> loadMetadata() {
        List tableNamesMetadata = null;
        try {
            tableNamesMetadata = ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts();
        }
        catch (NoSuchMetadataException e) {
            tableNamesMetadata = Lists.newArrayList();
        }
        return tableNamesMetadata;
    }

    protected List<TextTypeWrapperMutableBean> getNamesMetadata(List<LocalizedText> metadataValues, String defaultValue, String defaultLocale) {
        ArrayList response = Lists.newArrayList();
        if (metadataValues.size() == 0 && defaultValue != null) {
            this.log.warn("Names Metadata: using default value " + defaultValue);
            response.add(new TextTypeWrapperMutableBeanImpl(defaultLocale, defaultValue));
        } else {
            for (LocalizedText text : metadataValues) {
                this.log.debug("Adding metadata value " + text.getValue() + " " + text.getLocale());
                response.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
        }
        return response;
    }

    private Table getAssociatedCodelist(Column column) {
        this.log.debug("Looking for table associated to column " + column.getLocalId());
        ColumnRelationship cr = column.getRelationship();
        this.log.debug("Relationship " + cr);
        Table response = null;
        if (cr != null) {
            this.log.debug("Loading referenced table...");
            Table relatedTable = this.cubeManager.getTable(cr.getTargetTableId());
            if (relatedTable.getTableType().getCode().equals("CODELIST")) {
                this.log.debug("Table found " + relatedTable.getName());
                response = relatedTable;
            } else {
                this.log.debug("Referenced table is not a codelist");
            }
        } else {
            this.log.debug("No related table found");
        }
        return response;
    }

    protected abstract void registerData(DataStructureBean var1, Table var2, List<Column> var3, DatabaseConnectionProvider var4);

    private class Parameters {
        String registryUrl;
        String targetAgency;
        String targetId;
        String targetVersion;
        Column primaryMeasure;
        BasicCredentials credentials;

        private Parameters() {
        }
    }
}

