package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.impl;

import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataStructureDefinitionAbstractExporter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataStructureDefinitionBasicExporter extends SDMXDataStructureDefinitionAbstractExporter {

	private Logger logger;
	
	public SDMXDataStructureDefinitionBasicExporter(Table table, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation,CubeManager cubeManager) {
		super (table,connectionProvider,invocation,cubeManager);
		this.logger = LoggerFactory.getLogger(this.getClass());
	}
	
	@Override
	protected void extraOperation(DataStructureBean dataStructure) {
		this.logger.debug("No extra operation planned");
	}

	@Override
	protected void registerTimeDimensionColumn(Column column, ConceptMutableBean concept,
			DataStructureBean dataStructure) {
		this.logger.debug("No data registration required");

	}

	@Override
	protected void registerDimensionColumn(Column column, ConceptMutableBean concept, CodelistBean immutableCodelist,
			DataStructureBean dataStructure) {
		this.logger.debug("No data registration required");

	}

	@Override
	protected void registerAttributeColumn(Column column, ConceptMutableBean concept, CodelistBean immutableCodelist,
			DataStructureBean dataStructure) {
		this.logger.debug("No data registration required");

	}

	@Override
	protected void registerMeasureColumn(Column column, ConceptMutableBean concept, DataStructureBean dataStructure) {
		this.logger.debug("No data registration required");

	}

	@Override
	protected DataStructureBean createDataStructureBean(Table table,String targetAgency, String targetVersion, String targetId,List<LocalizedText> tableNamesMetadata) {
		DataStructureMutableBean dataStructureDefinition = new DataStructureMutableBeanImpl();
		dataStructureDefinition.setAgencyId(targetAgency);
		dataStructureDefinition.setVersion(targetVersion);
		String dsdId = targetId+"_DSD";
		dataStructureDefinition.setId(dsdId);
		dataStructureDefinition.setNames(getNamesMetadata(tableNamesMetadata,targetId+" Data Structure Definition", "en"));
		DataStructureBean response = new DataStructureBean();
		response.setDsd(dataStructureDefinition);
		return response;
	}

	@Override
	protected void registerPrimaryMeasure(Column column, ConceptMutableBean concept, DataStructureBean dataStructure) {
		this.logger.debug("No primary measure registration required");
		
	}

	@Override
	protected void registerData(DataStructureBean dataStructure, Table table, List<Column> columns,
			DatabaseConnectionProvider connectionProvider) {
		this.logger.debug("No data registration required");

		
	}

}
