/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.codelist;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.factories.AnnotationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeDescriptionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeNameColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXBaseCodelistImporter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CubeManager cubeManager;
    private String url;
    private CodelistBean codelist;
    private DatabaseConnectionProvider connectionProvider;
    private Map<String, ColumnLocalId> namesMapping;
    private Map<String, ColumnLocalId> descriptionsMapping;
    private Map<String, ColumnLocalId> annotationsMapping;

    public SDMXBaseCodelistImporter(CubeManager cubeManager, CodelistBean codelist, DatabaseConnectionProvider connectionProvider, String registryUrl) {
        this.cubeManager = cubeManager;
        this.codelist = codelist;
        this.connectionProvider = connectionProvider;
        this.url = registryUrl;
    }

    public Table addStructureMetadata(String agency, String version, Table table) throws WorkerException {
        try {
            TableMetaCreator tmc = this.cubeManager.modifyTableMeta(table.getId());
            TableDescriptorMetadata newTableDescriptorMetadata = null;
            try {
                TableDescriptorMetadata oldMetadata = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
                newTableDescriptorMetadata = new TableDescriptorMetadata(oldMetadata.getName(), version, agency, oldMetadata.getRefId());
            }
            catch (Exception e) {
                this.log.debug("Unable to find TableDescriptorMetadata");
                newTableDescriptorMetadata = new TableDescriptorMetadata(null, null, agency, 0L);
            }
            tmc.setTableMetadata(new TableMetadata[]{newTableDescriptorMetadata});
            return tmc.create();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to modify table metadata.", (Throwable)e);
        }
    }

    public Table addImportMetadata(TableId tableId) throws WorkerException {
        try {
            TableMetaCreator tmc = this.cubeManager.modifyTableMeta(tableId);
            tmc.setTableMetadata(new TableMetadata[]{new ImportMetadata("SDMX", this.url, new Date())});
            ArrayList<ImmutableLocalizedText> texts = new ArrayList<ImmutableLocalizedText>();
            for (Object text : this.codelist.getNames()) {
                texts.add(new ImmutableLocalizedText(text.getValue(), text.getLocale()));
            }
            NamesMetadata namesMetadata = new NamesMetadata(texts);
            tmc.setTableMetadata(new TableMetadata[]{namesMetadata});
            if (!this.codelist.getDescriptions().isEmpty()) {
                texts = new ArrayList();
                for (TextTypeWrapper text : this.codelist.getDescriptions()) {
                    texts.add(new ImmutableLocalizedText(text.getValue(), text.getLocale()));
                }
                DescriptionsMetadata descriptionsMetadata = new DescriptionsMetadata(texts);
                tmc.setTableMetadata(new TableMetadata[]{descriptionsMetadata});
            }
            tmc.setTableMetadata(new TableMetadata[]{new VersionMetadata(this.codelist.getVersion())});
            return tmc.create();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to modify table metadata.", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Table importCodelist() throws WorkerException {
        List codes = this.codelist.getItems();
        this.checkCodes(codes);
        Table table = this.createBaseTable(codes);
        this.log.debug("Created table: " + table);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            for (CodeBean code : codes) {
                Column relatedColumn;
                ArrayList columnNames = Lists.newArrayList();
                ArrayList columnValues = Lists.newArrayList();
                columnNames.add(((Column)table.getColumnsByType(new Class[]{CodeColumnType.class}).get(0)).getName());
                columnValues.add(code.getId());
                for (TextTypeWrapper codename : code.getNames()) {
                    relatedColumn = table.getColumnById(this.namesMapping.get(codename.getLocale()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(codename.getValue().replaceAll("'", "''"));
                }
                for (TextTypeWrapper codeDescription : code.getDescriptions()) {
                    relatedColumn = table.getColumnById(this.descriptionsMapping.get(codeDescription.getLocale()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(codeDescription.getValue().replaceAll("'", "''"));
                }
                for (AnnotationBean annotation : code.getAnnotations()) {
                    if (annotation.getTitle() == null || annotation.getText().isEmpty()) continue;
                    relatedColumn = table.getColumnById(this.annotationsMapping.get(annotation.getTitle()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(((TextTypeWrapper)annotation.getText().get(0)).getValue().replaceAll("'", "''"));
                }
                StringBuilder sql = this.createSQLStatement(table.getName(), columnNames, columnValues);
                this.log.trace("Appending SQL query to batch command:\n" + sql.toString());
                stmt.addBatch(sql.toString());
            }
            this.log.debug("Executing query...");
            stmt.executeBatch();
            rs = stmt.getResultSet();
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute database query.";
                this.log.error(msg, (Throwable)e);
                if (e.getNextException() != null) {
                    this.log.error("Inner Exception: ", (Throwable)e.getNextException());
                }
                throw new WorkerException(msg, (Throwable)e);
                catch (NoSuchColumnException e2) {
                    throw new WorkerException("Unable to build SQL statement", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        this.log.debug("Table has been populated");
        return table;
    }

    private Table createBaseTable(List<CodeBean> codes) throws WorkerException {
        Column column;
        TableCreator tc = this.cubeManager.createTable((TableType)new CodelistTableType());
        tc.addColumn(new CodeColumnFactory().createDefault());
        this.namesMapping = new HashMap<String, ColumnLocalId>();
        this.descriptionsMapping = new HashMap<String, ColumnLocalId>();
        this.annotationsMapping = new HashMap<String, ColumnLocalId>();
        ArrayList<String> nameLocales = new ArrayList<String>();
        ArrayList<String> descriptionLocales = new ArrayList<String>();
        ArrayList<String> annotationTitles = new ArrayList<String>();
        this.collectLocalesAndAnnotationTitles(codes, nameLocales, descriptionLocales, annotationTitles);
        this.log.debug("Collected name locales: " + nameLocales);
        this.log.debug("Collected description locales: " + descriptionLocales);
        this.log.debug("Collected annotation titles: " + annotationTitles);
        for (String nameLocale : nameLocales) {
            column = new CodeNameColumnFactory().create(nameLocale);
            tc.addColumn(column);
            if (this.namesMapping.containsKey(nameLocale)) continue;
            this.namesMapping.put(nameLocale, column.getLocalId());
        }
        for (String descriptionLocale : descriptionLocales) {
            column = new CodeDescriptionColumnFactory().create(descriptionLocale);
            tc.addColumn(column);
            if (this.descriptionsMapping.containsKey(descriptionLocale)) continue;
            this.descriptionsMapping.put(descriptionLocale, column.getLocalId());
        }
        for (String annotationTitle : annotationTitles) {
            if (this.annotationsMapping.containsKey(annotationTitle)) continue;
            column = new AnnotationColumnFactory().create((LocalizedText)new ImmutableLocalizedText(annotationTitle), new DataLocaleMetadata("en"));
            tc.addColumn(column);
            this.annotationsMapping.put(annotationTitle, column.getLocalId());
        }
        Table table = null;
        try {
            table = tc.create();
        }
        catch (TableCreationException e) {
            String msg = "Error occurred while trying to create the table.";
            this.log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
        return table;
    }

    private void collectLocalesAndAnnotationTitles(List<CodeBean> codes, List<String> nameLocales, List<String> descriptionLocales, List<String> annotationTitles) {
        for (CodeBean code : codes) {
            for (TextTypeWrapper textType : code.getNames()) {
                if (textType.getLocale() == null | textType.getLocale().isEmpty() || nameLocales.contains(textType.getLocale())) continue;
                nameLocales.add(textType.getLocale());
            }
            for (TextTypeWrapper textType : code.getDescriptions()) {
                if (textType.getLocale() == null | textType.getLocale().isEmpty() || descriptionLocales.contains(textType.getLocale())) continue;
                descriptionLocales.add(textType.getLocale());
            }
            for (AnnotationBean annotation : code.getAnnotations()) {
                String annotationTitle;
                if (annotation.getTitle() == null | annotation.getTitle().isEmpty() || annotationTitles.contains(annotationTitle = annotation.getTitle())) continue;
                annotationTitles.add(annotationTitle);
            }
        }
    }

    private StringBuilder createSQLStatement(String tableName, List<String> columnNames, List<String> columnValues) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("INSERT INTO %s ( ", tableName));
        for (String columnName : columnNames) {
            sql.append(columnName + " , ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" ) VALUES (");
        for (String columnValue : columnValues) {
            sql.append(String.format(" '%s' , ", columnValue));
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(");");
        return sql;
    }

    private void checkCodes(List<CodeBean> codes) throws WorkerException {
        if (codes.isEmpty()) {
            throw new WorkerException("Codelist [%s,%s,%s] does not contain codes.");
        }
    }
}

