/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.codelist;

import java.util.Map;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXBaseCodelistImporter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistImporter
extends DataWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private OperationInvocation operationInvocation;
    private String url;
    private String agency;
    private String id;
    private String version;
    private String username;
    private String password;

    public SDMXCodelistImporter(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, OperationInvocation operationInvocation) {
        super(operationInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.operationInvocation = operationInvocation;
        this.username = null;
        this.password = null;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Connecting to repository");
        try {
            SDMXRegistryClient registryClient = WorkerUtils.initSDMXClient(this.url, this.username, this.password);
            this.updateProgress(0.2f, "Getting beans");
            CodelistBean codelist = this.getCodelistBean(registryClient);
            SDMXBaseCodelistImporter baseImporter = new SDMXBaseCodelistImporter(this.cubeManager, codelist, this.connectionProvider, this.url);
            this.updateProgress(0.4f, "Importing data");
            Table table = baseImporter.importCodelist();
            this.updateProgress(0.8f, "Creating resource");
            Table agencyTable = baseImporter.addStructureMetadata(codelist.getAgencyId(), codelist.getVersion(), table);
            Table resultTable = baseImporter.addImportMetadata(agencyTable.getId());
            return new ImmutableWorkerResult(resultTable);
        }
        catch (RuntimeException e) {
            this.log.error("Unable to complete import procedure", (Throwable)e);
            throw new WorkerException("Unable to complete import procedure", (Throwable)e);
        }
    }

    private void retrieveParameters() {
        Map parameters = this.operationInvocation.getParameterInstances();
        this.url = (String)parameters.get("registryBaseUrl");
        this.agency = (String)parameters.get("agency");
        this.id = (String)parameters.get("id");
        this.version = (String)parameters.get("version");
        BasicCredentials credentials = RegistryInformationProvider.retrieveCredentials((String)this.url);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    private CodelistBean getCodelistFromBeans(SdmxBeans sdmxBeans, String agencyId, String id, String version) {
        Set codelistBeans = sdmxBeans.getCodelists();
        this.log.debug("Retrieved codelists: " + codelistBeans);
        if (codelistBeans.size() < 1) {
            throw new RuntimeException(String.format("Unable to find a codelist with the given coordinates: [%s,%s,%s]", agencyId, id, version));
        }
        if (codelistBeans.size() > 1) {
            throw new RuntimeException(String.format("Found too many codelists for the given coordinates: [%s,%s,%s]", agencyId, id, version));
        }
        return (CodelistBean)codelistBeans.iterator().next();
    }

    private CodelistBean getCodelistBean(SDMXRegistryClient registryClient) {
        SdmxBeans sdmxBeans = null;
        try {
            sdmxBeans = registryClient.getCodelist(this.agency, this.id, this.version, SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
            this.log.debug("Retrieved beans: " + sdmxBeans);
        }
        catch (SDMXRegistryClientException e) {
            String msg = "Error occurred while retrieving codelist.";
            this.log.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
        CodelistBean codelist = this.getCodelistFromBeans(sdmxBeans, this.agency, this.id, this.version);
        return codelist;
    }
}

