/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.export.csv.exporter.CSVExportFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperation;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;

@Singleton
public class ExportToStatisticalOperationFactory
extends ExportWorkerFactory {
    private static OperationId OPERATION_ID = new OperationId(10002L);
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    private CSVExportFactory csvExportFactory;
    private CubeManager cubeManager;

    static {
        parameters.add((Parameter)StatisticalOperationFactory.USER);
    }

    @Inject
    public ExportToStatisticalOperationFactory(CSVExportFactory csvExportFactory, CubeManager cubeManager) {
        this.csvExportFactory = csvExportFactory;
        this.cubeManager = cubeManager;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        StatisticalManagerDataSpace dataSpace = null;
        try {
            dataSpace = (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().build();
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Unable to contact statistical manager service", e);
        }
        return new ExportToStatisticalOperation(invocation, this.csvExportFactory, this.cubeManager, dataSpace);
    }

    protected String getOperationName() {
        return "Export to Statistical";
    }

    protected String getOperationDescription() {
        return "Export the target table to the user's dataspace of Statistical Manager";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

