/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import com.rapidminer.gui.tools.syntax.InputHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableResourceCreatorWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperation;

@Singleton
public class StatisticalOperationFactory
extends TableResourceCreatorWorkerFactory {
    private static OperationId OPERATION_ID = new OperationId(10001L);
    public static SimpleStringParameter USER = new SimpleStringParameter("user", "User", "Username", Cardinality.ONE);
    public static SimpleStringParameter ALGORITHM = new SimpleStringParameter("algorithm", "Algorithm", "SM Algorithm to execute", Cardinality.ONE);
    public static MapParameter SM_ENTRIES = new MapParameter("smEntries", "SM Entries", "Input parameters required by SM algorithm", Cardinality.ONE, String.class, Object.class);
    public static SimpleStringParameter DESCRIPTION = new SimpleStringParameter("description", "Description", "Description of the experiment", Cardinality.OPTIONAL);
    public static SimpleStringParameter TITLE = new SimpleStringParameter("title", "Title", "Title of the experiment", Cardinality.OPTIONAL);
    public static BooleanParameter CLEAR_DATASPACE = new BooleanParameter("clear", "Clear Dataspace", "Remove all generated resources from dataspace", Cardinality.OPTIONAL);
    public static BooleanParameter REMOVE_EXPORTED = new BooleanParameter("remove", "Remove Exported", "Remove table from dataspace", Cardinality.OPTIONAL);
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private CubeManager cubeManager;

    static {
        parameters.add((Parameter)USER);
        parameters.add((Parameter)ALGORITHM);
        parameters.add((Parameter)SM_ENTRIES);
        parameters.add((Parameter)DESCRIPTION);
        parameters.add((Parameter)TITLE);
        parameters.add((Parameter)CLEAR_DATASPACE);
        parameters.add((Parameter)REMOVE_EXPORTED);
    }

    @Inject
    public StatisticalOperationFactory(ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, CubeManager cubeManager) {
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.cubeManager = cubeManager;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        StatisticalManagerFactory factory = null;
        InputHandler.Home home = null;
        try {
            factory = Common.getSMFactory();
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, Constants.SERVICE_NOT_FOUND, e);
        }
        StatisticalOperationFactory.checkSMParameters(factory, invocation);
        return new StatisticalOperation(invocation, factory, this.exportFactory, this.importFactory, home, this.cubeManager);
    }

    private static void checkSMParameters(StatisticalManagerFactory factory, OperationInvocation invocation) throws InvalidInvocationException {
        try {
            String algorithmId = (String)OperationHelper.getParameter((LeafParameter)ALGORITHM, (OperationInvocation)invocation);
            Map entries = (Map)invocation.getParameterInstances().get(SM_ENTRIES.getIdentifier());
            if (!Common.isSMAlgorithmAvailable(algorithmId)) {
                throw new InvalidInvocationException(invocation, Constants.ALGORITHM_NOT_FOUND);
            }
            SMParameters params = factory.getAlgorithmParameters(algorithmId);
            for (SMParameter param : params.list()) {
                if (entries.containsKey(param.name()) || entries.get(param.name()) == null) continue;
                throw new InvalidInvocationException(invocation, "Requested algorithm parameter " + param.name() + " not specified or null.");
            }
        }
        catch (InvalidInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Unable to check parameters for selected algorithm");
        }
    }

    protected String getOperationName() {
        return "Statistical Operation";
    }

    protected String getOperationDescription() {
        return "Execute a Statistical Manager experiment against the selected target table";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        String algorithmId = (String)OperationHelper.getParameter((LeafParameter)ALGORITHM, (OperationInvocation)invocation);
        return String.format("Execute %s Algorithm", algorithmId);
    }

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }
}

