/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.maps;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.TableScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GenerateMapWorker;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GeoPublishingConfiguration;
import org.gcube.data.analysis.tabulardata.operation.view.maps.NotSupportedGeometryShapeException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.spatial.data.gis.symbology.GeometryType;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GenerateMapFactory
extends TableScopedWorkerFactory<ResourceCreatorWorker> {
    private static final OperationId OPERATION_ID = new OperationId(1010L);
    private static Logger logger = LoggerFactory.getLogger(GenerateMapFactory.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connProvider;
    private static final List<ColumnType> ALL_COLUMNS = new ArrayList<ColumnType>();
    private static final List<TableType> ALL_TABLES = new ArrayList<TableType>();
    private static final List<DataType> ALL_BUT_GEOMETRY_DATA_TYPES = new ArrayList<DataType>();
    public static SimpleStringParameter mapName;
    public static TargetColumnParameter toCreateFeatureTypes;
    public static final BooleanParameter useView;
    public static TargetColumnParameter toUseGeometry;
    public static SimpleStringParameter metaAbstract;
    public static SimpleStringParameter metaPurpose;
    public static SimpleStringParameter user;
    public static SimpleStringParameter metaCredits;
    public static SimpleStringParameter keywords;
    private static final List<Parameter> params;

    static {
        ALL_COLUMNS.add((ColumnType)new AnnotationColumnType());
        ALL_COLUMNS.add((ColumnType)new AttributeColumnType());
        ALL_COLUMNS.add((ColumnType)new CodeColumnType());
        ALL_COLUMNS.add((ColumnType)new CodeDescriptionColumnType());
        ALL_COLUMNS.add((ColumnType)new CodeNameColumnType());
        ALL_COLUMNS.add((ColumnType)new DimensionColumnType());
        ALL_COLUMNS.add((ColumnType)new MeasureColumnType());
        ALL_COLUMNS.add((ColumnType)new TimeDimensionColumnType());
        ALL_TABLES.add((TableType)new CodelistTableType());
        ALL_TABLES.add((TableType)new DatasetTableType());
        ALL_TABLES.add((TableType)new DatasetViewTableType());
        ALL_TABLES.add((TableType)new GenericTableType());
        ALL_TABLES.add((TableType)new HierarchicalCodelistTableType());
        ALL_TABLES.add((TableType)new TimeCodelistTableType());
        ALL_BUT_GEOMETRY_DATA_TYPES.add((DataType)new BooleanType());
        ALL_BUT_GEOMETRY_DATA_TYPES.add((DataType)new DateType());
        ALL_BUT_GEOMETRY_DATA_TYPES.add((DataType)new IntegerType());
        ALL_BUT_GEOMETRY_DATA_TYPES.add((DataType)new NumericType());
        ALL_BUT_GEOMETRY_DATA_TYPES.add((DataType)new TextType());
        mapName = new SimpleStringParameter("mapName", "Map Name", "Name by which publish the map.", Cardinality.ONE);
        toCreateFeatureTypes = new TargetColumnParameter("feature", "Feature", "To create feature", new Cardinality(1, Integer.MAX_VALUE), ALL_TABLES, ALL_COLUMNS, ALL_BUT_GEOMETRY_DATA_TYPES);
        useView = new BooleanParameter("useView", "Use View", "Use view columns values instead of dimensions", Cardinality.ONE);
        toUseGeometry = new TargetColumnParameter("geom", "Geometry", "To use Geometry", Cardinality.OPTIONAL, ALL_TABLES, ALL_COLUMNS, Collections.singletonList(new org.gcube.data.analysis.tabulardata.model.datatype.GeometryType()));
        metaAbstract = new SimpleStringParameter("metaAbstract", "Abstract", "Abstract to publish the layer with", Cardinality.ONE);
        metaPurpose = new SimpleStringParameter("metaPurpose", "Purpose", "Purpose of the layer", Cardinality.ONE);
        user = new SimpleStringParameter("User", "User", "Author of the map", Cardinality.ONE);
        metaCredits = new SimpleStringParameter("metaCredits", "Credits", "Credits", Cardinality.ONE);
        keywords = new SimpleStringParameter("metaKeywords", "Metadata keywords", "Keywords to associate to this layer", new Cardinality(0, Integer.MAX_VALUE));
        params = Arrays.asList(mapName, toUseGeometry, toCreateFeatureTypes, useView, metaAbstract, metaPurpose, user, metaCredits, keywords);
    }

    @Inject
    public GenerateMapFactory(CubeManager cubeManager, DatabaseConnectionProvider connProvider) {
        this.cubeManager = cubeManager;
        this.connProvider = connProvider;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        this.checkParameters(arg0);
        GeoPublishingConfiguration geoConfig = null;
        try {
            geoConfig = GeoPublishingConfiguration.get();
        }
        catch (Exception e) {
            logger.error("Wrong GIS environement (Scope : " + ScopeProvider.instance.get() + ")", (Throwable)e);
            throw new InvalidInvocationException(arg0, "Environment doesn't support GIS features");
        }
        return new GenerateMapWorker(arg0, this.cubeManager, this.connProvider, geoConfig);
    }

    private void checkParameters(OperationInvocation arg0) throws InvalidInvocationException {
        Object toRepresentColumn;
        Table targetTable = this.cubeManager.getTable(arg0.getTargetTableId());
        boolean useView = (Boolean)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.useView, (OperationInvocation)arg0);
        if (useView && targetTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)targetTable.getMetadata(DatasetViewTableMetadata.class);
            targetTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        if ((toRepresentColumn = arg0.getParameterInstances().get(toCreateFeatureTypes.getIdentifier())) instanceof ColumnReference) {
            try {
                targetTable.getColumnById(((ColumnReference)toRepresentColumn).getColumnId());
            }
            catch (NoSuchColumnException e) {
                throw new InvalidInvocationException(arg0, "Wrong parameter " + toCreateFeatureTypes.getName() + ".Column not found");
            }
        } else {
            for (ColumnReference ref : (Iterable)toRepresentColumn) {
                try {
                    targetTable.getColumnById(ref.getColumnId());
                }
                catch (NoSuchColumnException e) {
                    throw new InvalidInvocationException(arg0, "Wrong parameter " + toCreateFeatureTypes.getName() + ".Column not found");
                }
            }
        }
        if (!arg0.getParameterInstances().containsKey(toUseGeometry.getIdentifier())) {
            boolean foundGeom = false;
            for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
                if (!(col.getDataType() instanceof org.gcube.data.analysis.tabulardata.model.datatype.GeometryType)) continue;
                if (!foundGeom) {
                    foundGeom = true;
                    continue;
                }
                throw new InvalidInvocationException(arg0, "Multiple geometry columns found in current table");
            }
            if (!foundGeom) {
                throw new InvalidInvocationException(arg0, "No Geometry column found");
            }
        } else {
            ColumnReference geomRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)toUseGeometry, (OperationInvocation)arg0);
            Column geom = targetTable.getColumnById(geomRef.getColumnId());
            if (!(geom.getDataType() instanceof org.gcube.data.analysis.tabulardata.model.datatype.GeometryType)) {
                throw new InvalidInvocationException(arg0, "Invalid selected geometry column");
            }
        }
    }

    public Class<ResourceCreatorWorker> getWorkerType() {
        return ResourceCreatorWorker.class;
    }

    protected String getOperationDescription() {
        return "Generate a GIS layer from the table.";
    }

    protected String getOperationName() {
        return "Generate Map";
    }

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        this.performBaseChecks(toDescribeInvocation, this.cubeManager);
        this.checkParameters(toDescribeInvocation);
        Table target = this.cubeManager.getTable(toDescribeInvocation.getTargetTableId());
        String features = OperationHelper.getColumnLabelsSnippet(GenerateMapFactory.getSelectedFeatureTypes(toDescribeInvocation, target, this.cubeManager));
        return "Generate " + features + " GIS features";
    }

    static List<Column> getSelectedFeatureTypes(OperationInvocation arg0, Table targetTable, CubeManager cubeManager) {
        boolean useView = (Boolean)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.useView, (OperationInvocation)arg0);
        if (useView && targetTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)targetTable.getMetadata(DatasetViewTableMetadata.class);
            targetTable = cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        ArrayList<Column> toReturn = new ArrayList<Column>();
        Object toRepresentColumn = arg0.getParameterInstances().get(toCreateFeatureTypes.getIdentifier());
        if (toRepresentColumn instanceof ColumnReference) {
            toReturn.add(GenerateMapFactory.getColumn((ColumnReference)toRepresentColumn, targetTable, useView));
        } else {
            for (ColumnReference ref : (Iterable)toRepresentColumn) {
                toReturn.add(GenerateMapFactory.getColumn(ref, targetTable, useView));
            }
        }
        return toReturn;
    }

    private static Column getColumn(ColumnReference ref, Table table, boolean useView) {
        Column col = table.getColumnById(ref.getColumnId());
        if (useView && col.getColumnType() instanceof DimensionColumnType) {
            ColumnLocalId referredId = col.getRelationship().getTargetColumnId();
            return table.getColumnById(referredId);
        }
        return col;
    }

    public static GeometryType getGeometryType(Table table, Column geometryColumn, DatabaseConnectionProvider connProvider) throws SQLException, NotSupportedGeometryShapeException {
        int geoType;
        block5: {
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block4: {
                GeometryType geometryType;
                conn = null;
                stmt = null;
                rs = null;
                try {
                    conn = connProvider.getConnection();
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(String.format("SELECT %s from %s limit 1", geometryColumn.getName(), table.getName()));
                    rs.next();
                    PGgeometry geom = (PGgeometry)rs.getObject(1);
                    geoType = geom.getGeoType();
                    if (geoType != 1) break block4;
                    geometryType = GeometryType.POINT;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(rs);
                    DbUtils.closeQuietly((Statement)stmt);
                    DbUtils.closeQuietly((Connection)conn);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
                return geometryType;
            }
            if (geoType != 3) break block5;
            GeometryType geometryType = GeometryType.POLYGON;
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return geometryType;
        }
        throw new NotSupportedGeometryShapeException("Found geometry type " + Geometry.getTypeString((int)geoType));
    }
}

