/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.maps;

import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.operation.view.maps.CachedObject;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GeoPublishingParameters;
import org.gcube.data.analysis.tabulardata.operation.view.maps.XMLAdapterImpl;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.gis.GISInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPublishingConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GeoPublishingConfiguration.class);
    private static ConcurrentHashMap<String, CachedObject<GeoPublishingConfiguration>> configurationMap = new ConcurrentHashMap();
    private GeoPublishingParameters params;
    private String postgisUrl;
    private String postgisUser;
    private String postgisPwd;
    private GISInterface gis = GISInterface.get();
    private static JAXBContext jaxbContext;

    public static synchronized GeoPublishingConfiguration get() throws Exception {
        String currentScope = ScopeProvider.instance.get();
        if (!configurationMap.containsKey(currentScope) || !configurationMap.get(currentScope).isvalid()) {
            configurationMap.put(currentScope, new CachedObject<GeoPublishingConfiguration>(new GeoPublishingConfiguration()));
        }
        return new GeoPublishingConfiguration();
    }

    private GeoPublishingConfiguration() throws Exception {
        this.gis.setToRegisterXMLAdapters(Collections.singletonList(new XMLAdapterImpl()));
        logger.debug("Current GeoServer descriptor is " + this.gis.getCurrentGeoServerDescriptor());
        this.params = GeoPublishingConfiguration.getParameters();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + this.params.getGisDBCategory() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + this.params.getGisDBPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        boolean foundDBAccess = false;
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            Map map = point.propertyMap();
            if (!point.name().equals(this.params.getAccessPointName()) || !map.containsKey(this.params.getTdmDataStoreFlag()) || !Boolean.parseBoolean(((ServiceEndpoint.Property)map.get(this.params.getTdmDataStoreFlag())).value())) continue;
            this.postgisUrl = this.params.getUrlPrefix() + point.address();
            this.postgisUser = point.username();
            this.postgisPwd = StringEncrypter.getEncrypter().decrypt(point.password(), new Key[0]);
            foundDBAccess = true;
            break;
        }
        if (!foundDBAccess) {
            throw new Exception("Unable to locate remote DB Endpoint");
        }
    }

    public String getPostgisPwd() {
        return this.postgisPwd;
    }

    public String getPostgisUrl() {
        return this.postgisUrl;
    }

    public String getPostgisUser() {
        return this.postgisUser;
    }

    public GeoPublishingParameters getParams() {
        return this.params;
    }

    public GISInterface getGis() {
        return this.gis;
    }

    private static GeoPublishingParameters getParameters() throws Exception {
        XQuery paramsQuery = ICFactory.queryFor(GenericResource.class);
        paramsQuery.addCondition("$resource/Profile/SecondaryType/text() eq 'TDMConfiguration'");
        DiscoveryClient pqClient = ICFactory.clientFor(GenericResource.class);
        for (GenericResource res : pqClient.submit((Query)paramsQuery)) {
            try {
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                return (GeoPublishingParameters)unmarshaller.unmarshal((Reader)new StringReader(res.profile().bodyAsString()));
            }
            catch (Exception e) {
                logger.debug("Invalid resource {}", (Object)res.id());
            }
        }
        throw new Exception("No TDMConfiguration found ");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeoPublishingConfiguration [params=");
        builder.append(this.params);
        builder.append(", postgisUrl=");
        builder.append(this.postgisUrl);
        builder.append(", postgisUser=");
        builder.append(this.postgisUser);
        builder.append(", postgisPwd=");
        builder.append(this.postgisPwd);
        builder.append(", gis=");
        builder.append(this.gis);
        builder.append("]");
        return builder.toString();
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GeoPublishingParameters.class});
        }
        catch (Exception e) {
            logger.error("Unable to initiate context ", (Throwable)e);
        }
    }
}

