/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.query;

import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.QueryManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterfaceImpl
implements QueryInterface {
    private static Logger logger = LoggerFactory.getLogger(QueryInterfaceImpl.class);
    private static QueryManagerProxy queryManager = (QueryManagerProxy)AbstractPlugin.query().build();

    public Table getTable(TableId tableId) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.getTable(tableId.getValue());
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }

    public int getQueryLenght(TableId tableId, QueryFilter filter) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.getQueryLenght(tableId.getValue(), filter);
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.queryAsJson(tableId.getValue(), page, filter, order);
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.queryAsJson(tableId.getValue(), page, filter, null);
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.queryAsJson(tableId.getValue(), page, null, order);
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }

    public String queryAsJson(TableId tableId, QueryPage page) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException {
        try {
            return queryManager.queryAsJson(tableId.getValue(), page, null, null);
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found", (Object)tableId, (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException(tableId);
        }
    }
}

