package org.gcube.data.td.commons.webservice.types;

import java.util.Calendar;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJob;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.td.commons.webservice.exception.ThrowableAdapter;

import com.google.common.collect.Lists;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class TaskInfo{

	@XmlElement
	private String identifier;

	@XmlElement
	private Calendar startTime;
	
	@XmlElement
	private Calendar endTime;
	
	@XmlElementRef(type=ImmutableJob.class)
	private List<Job> jobs = Lists.newArrayList();
	
	@XmlElementRef(type=ImmutableJobResult.class)
	private JobResult jobResult;
	
	@XmlElement
	private ActivityStatus status;
	
	@XmlJavaTypeAdapter(ThrowableAdapter.class)
	private Throwable errorCause;
	
	TaskInfo(){}
	
	public TaskInfo(String id){
		this.identifier = id;
	}
		
	/**
	 * @return the identifier
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * @return the startTime
	 */
	public Calendar getStartTime() {
		return startTime;
	}

	/**
	 * @return the endTime
	 */
	public Calendar getEndTime() {
		return endTime;
	}

	/**
	 * @return the jobs
	 */
	public List<Job> getJobs() {
		return jobs;
	}

	/**
	 * @param jobs the jobs to set
	 */
	public void setJobs(List<Job> jobs) {
		this.jobs = jobs;
	}

	/**
	 * @return the jobResult
	 */
	public JobResult getJobResult() {
		return jobResult;
	}

	/**
	 * @param jobResult the jobResult to set
	 */
	public void setJobResult(JobResult jobResult) {
		this.jobResult = jobResult;
	}

	/**
	 * @return the status
	 */
	public ActivityStatus getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(ActivityStatus status) {
		this.status = status;
	}

	/**
	 * @param startTime the startTime to set
	 */
	public void setStartTime(Calendar startTime) {
		this.startTime = startTime;
	}

	/**
	 * @param endTime the endTime to set
	 */
	public void setEndTime(Calendar endTime) {
		this.endTime = endTime;
	}

	public Throwable getErrorCause() {
		return errorCause;
	}

	public void setErrorCause(Throwable errorCause) {
		this.errorCause = errorCause;
	}


	
}
