package org.gcube.data.td.commons.webservice;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.td.commons.utils.Constants;
import org.gcube.data.td.commons.webservice.exception.NoSuchTableException;

@WebService(targetNamespace=Constants.TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface QueryManager {

	public static final String SERVICE_NAME = "querymanager";
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	public Table getTable(long tableId) throws NoSuchTableException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	public abstract String queryAsJson(long tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException;
	
	public int getQueryLenght(long tableId, QueryFilter filter) throws NoSuchTableException;

}
