
package org.gcube.data.td.commons.webservice.types;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class HistoryData {

	@XmlElement
	OperationInvocation invocation;
	
	@XmlElement
	Table resultTable;

	protected HistoryData(){}
	
	public HistoryData(OperationInvocation invocation, Table resultTable) {
		super();
		this.invocation = invocation;
		this.resultTable = resultTable;
	}

	/**
	 * @return the invocation
	 */
	public OperationInvocation getInvocation() {
		return invocation;
	}

	/**
	 * @return the resultTable
	 */
	public Table getResultTable() {
		return resultTable;
	}

	
}
