/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.FinalAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnDescription;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotEmpty
    private List<TemplateColumn<?>> columns;
    @NotNull
    private OnRowErrorAction onRowErrorAction = OnRowErrorAction.ASK;
    @NotNull
    private List<TemplateAction<Long>> actions = new ArrayList<TemplateAction<Long>>();
    @NotNull
    private FinalAction finalAction = FinalAction.NONE;
    private TemplateCategory category;

    public static Template create(TemplateCategory templateType, TemplateColumn<?> ... columns) {
        return new Template(templateType, columns);
    }

    private Template() {
    }

    private Template(TemplateCategory templateType, TemplateColumn<?>[] columns) {
        for (TemplateColumn<?> column : columns) {
            if (Template.containsColumnCategory(templateType.getAllowedColumn(), column.getColumnType())) continue;
            throw new IllegalArgumentException(String.format("column type %s not allowed for template type %s ", column.getColumnType().name(), templateType.name()));
        }
        this.columns = Arrays.asList(columns);
        this.category = templateType;
    }

    private static boolean containsColumnCategory(List<ColumnDescription> allowedColumns, ColumnCategory columnType) {
        for (ColumnDescription desc : allowedColumns) {
            if (desc.getColumnCategory() != columnType) continue;
            return true;
        }
        return false;
    }

    public List<TemplateColumn<?>> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TemplateColumn<?>> columns) {
        this.columns = columns;
    }

    public OnRowErrorAction getOnRowErrorAction() {
        return this.onRowErrorAction;
    }

    public void setOnErrorAction(OnRowErrorAction onErrorAction) {
        this.onRowErrorAction = onErrorAction;
    }

    public List<TemplateAction<Long>> getActions() {
        return this.actions;
    }

    public void setActions(List<TemplateAction<Long>> actions) {
        this.actions = actions;
    }

    public FinalAction getFinalAction() {
        return this.finalAction;
    }

    public void setFinalAction(FinalAction finalAction) {
        this.finalAction = finalAction;
    }

    public TemplateCategory getCategory() {
        return this.category;
    }

    public String toString() {
        return "Template [columns=" + this.columns + ", onErrorAction=" + (Object)((Object)this.onRowErrorAction) + ", actions=" + this.actions + ", finalAction=" + (Object)((Object)this.finalAction) + "]";
    }
}

