/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TemplateAction<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract boolean usesExpression();

    public abstract T getIdentifier();

    public abstract Map<String, Object> getParameters();

    public Map<String, Object> replaceColumnReferences(TableId tableId, Map<String, ColumnLocalId> columnMapping) {
        Map<String, Object> parameters = this.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return parameters;
        }
        return this.getNewInstanceMap(tableId, columnMapping, this.getParameters());
    }

    private Map<String, Object> getNewInstanceMap(TableId tableId, Map<String, ColumnLocalId> columnMapping, Map<String, Object> oldInstances) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : oldInstances.entrySet()) {
            if (entry.getValue() instanceof ColumnReference) {
                ColumnReference ref = (ColumnReference)entry.getValue();
                if (columnMapping.containsKey(ref.getColumnId().toString())) {
                    ColumnLocalId newId = columnMapping.get(ref.getColumnId().toString());
                    ref.setColumnId(newId);
                }
                returnMap.put(entry.getKey(), ref);
            }
            if (entry.getValue() instanceof String && columnMapping.containsKey(entry.getValue())) {
                returnMap.put(entry.getKey(), columnMapping.get(entry.getValue()).getValue());
            }
            if (entry.getValue() instanceof Map) {
                Map compParam = (Map)entry.getValue();
                returnMap.put(entry.getKey(), this.getNewInstanceMap(tableId, columnMapping, compParam));
                continue;
            }
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }
}

