/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.webservice.OperationManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.TaskManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.BatchExecuteRequest;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.BatchOption;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.ExecuteRequest;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ResumeOperationRequest;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskStep;
import org.gcube.data.analysis.tabulardata.metadata.task.StorableTask;
import org.gcube.data.analysis.tabulardata.task.engine.TaskEngine;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="TaskeManagerPort", serviceName="taskmanager", targetNamespace="http://gcube-system.org/task", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.TaskManager")
@Singleton
@WeldService
public class TaskManagerImpl
implements TaskManager {
    private Logger logger = LoggerFactory.getLogger(TaskManagerImpl.class);
    @Inject
    EntityManagerHelper emHelper;
    @Inject
    TaskEngine taskEngine;
    @Inject
    OperationManager operationManager;

    @PreDestroy
    public void destroyTasks() {
        this.logger.trace("checking tasks before shutdown");
        this.abortUnfinishedTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo remove(String identifier) throws NoSuchTaskException, InternalSecurityException {
        EntityManager em = this.emHelper.getEntityManager();
        if (this.taskEngine.get(identifier, em).getSubmitter().equals(AuthorizationProvider.instance.get())) {
            throw new InternalSecurityException("trying to abort a task without authorization");
        }
        try {
            TaskInfo taskInfo = this.taskEngine.remove(identifier, em);
            return taskInfo;
        }
        finally {
            em.close();
        }
    }

    public List<TaskInfo> get(String[] identifiers) {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        EntityManager em = this.emHelper.getEntityManager();
        for (String id : identifiers) {
            try {
                tasks.add(this.taskEngine.get(id, em));
            }
            catch (NoSuchTaskException e) {
                this.logger.warn("task with id {} not found", (Object)id, (Object)e);
            }
        }
        em.close();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskInfo> getTasksByTabularResource(Long tabularResourceId) throws NoSuchTabularResourceException, InternalSecurityException {
        this.logger.info("requesting tasks for tabularResources with id {} ", (Object)tabularResourceId);
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("trid", tabularResourceId);
        parameters.put("user", AuthorizationProvider.instance.get().getClient().getId());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("scope", ScopeProvider.instance.get());
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        try (EntityManager em = this.emHelper.getEntityManager();){
            for (StorableTask task : this.emHelper.getResults("TASK.getByTr", StorableTask.class, parameters)) {
                try {
                    tasks.add(this.taskEngine.get(task.getIdentifier(), em));
                }
                catch (NoSuchTaskException e) {
                    this.logger.warn("unexpected exception", (Throwable)e);
                }
            }
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskInfo> getTasksByStatusAndTabularResource(Long tabularResourceId, TaskStatus status) throws NoSuchTabularResourceException, InternalSecurityException {
        this.logger.info("requesting tasks for tabularResources with id {} and status {} ", (Object)tabularResourceId, (Object)status);
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("trid", tabularResourceId);
        parameters.put("user", AuthorizationProvider.instance.get().getClient().getId());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("scope", ScopeProvider.instance.get());
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        try (EntityManager em = this.emHelper.getEntityManager();){
            for (StorableTask task : this.emHelper.getResults("TASK.getByTr", StorableTask.class, parameters)) {
                this.logger.trace("task found " + task.getStoredTask());
                try {
                    TaskInfo updatedTask = this.taskEngine.get(task.getIdentifier(), em);
                    if (updatedTask.getStatus() != status) continue;
                    tasks.add(updatedTask);
                }
                catch (NoSuchTaskException e) {
                    this.logger.warn("unexpected exception", (Throwable)e);
                }
            }
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortUnfinishedTask() {
        try (EntityManager em = this.emHelper.getEntityManager();){
            for (StorableTask task : this.emHelper.getResults("TASK.getAll", StorableTask.class)) {
                this.logger.trace("checking task " + task.getIdentifier() + " fro shutdown");
                if (task.getStoredTask().getStatus().isFinal()) continue;
                try {
                    this.taskEngine.abort(task.getStoredTask(), em);
                    this.logger.info("task " + task.getIdentifier() + " aborted");
                }
                catch (NoSuchTaskException e) {
                    this.logger.trace("task not found for abort");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo abort(String identifier) throws NoSuchTaskException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            TaskInfo info = this.taskEngine.get(identifier, em);
            if (info.getSubmitter().equals(AuthorizationProvider.instance.get())) {
                throw new InternalSecurityException("trying to abort a task without ownership");
            }
            this.taskEngine.abort(info, em);
            TaskInfo taskInfo = info;
            return taskInfo;
        }
    }

    public TaskInfo resubmit(String identifier) throws NoSuchTaskException, InternalSecurityException {
        EntityManager em = this.emHelper.getEntityManager();
        StorableTask oldTask = (StorableTask)em.find(StorableTask.class, (Object)identifier);
        em.close();
        if (oldTask == null) {
            throw new NoSuchTaskException(identifier);
        }
        if (oldTask.getStoredTask().getSubmitter().equals(AuthorizationProvider.instance.get())) {
            throw new InternalSecurityException("trying to resubmit a task without ownership");
        }
        if (!oldTask.getStoredTask().isResubmittable()) {
            throw new InternalSecurityException("the task " + identifier + " cannot be resubmitted");
        }
        ArrayList<OperationExecution> oldInvocation = new ArrayList<OperationExecution>(oldTask.getStoredTask().getTaskSteps().size());
        for (TaskStep step : oldTask.getStoredTask().getTaskSteps()) {
            oldInvocation.add(step.getSourceInvocation());
        }
        if (oldInvocation.size() == 1) {
            try {
                return this.operationManager.execute(new ExecuteRequest(oldTask.getTabularResource().getId(), (OperationExecution)oldInvocation.get(0)));
            }
            catch (Exception e) {
                this.logger.error("unexpected exception", (Throwable)e);
                throw new RuntimeException("unexpected exception", e);
            }
        }
        try {
            return this.operationManager.batchExecute(new BatchExecuteRequest(oldTask.getTabularResource().getId(), oldInvocation, BatchOption.ROLLBACK));
        }
        catch (Exception e) {
            this.logger.error("unexpected exception", (Throwable)e);
            throw new RuntimeException("unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo resume(ResumeOperationRequest request) throws NoSuchTaskException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTask oldTask = (StorableTask)em.find(StorableTask.class, (Object)request.getIdentifier());
            if (oldTask == null) {
                throw new NoSuchTaskException(request.getIdentifier());
            }
            if (oldTask.getStoredTask().getSubmitter().equals(AuthorizationProvider.instance.get())) {
                throw new InternalSecurityException("trying to resubmit a task without ownership");
            }
            if (oldTask.getStoredTask().getStatus() != TaskStatus.STOPPED) {
                throw new RuntimeException("the task " + request.getIdentifier() + " cannot be resubmitted (the status was not stopped)");
            }
            TaskInfo taskInfo = this.taskEngine.continueTaskExecution(oldTask, request.getCurrentOperationParameter());
            return taskInfo;
        }
    }
}

