/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.scope.impl.ScopedTasks;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.OperationTaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.RollbackTaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TemplateTaskInfo;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.metadata.task.StorableTask;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.executor.TaskWrapper;
import org.gcube.data.analysis.tabulardata.task.executor.TaskWrapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TaskEngine {
    private Logger logger = LoggerFactory.getLogger(TaskEngine.class);
    private ExecutorService executorService;
    private TaskWrapperProvider taskExecutorFactory;
    private static Map<String, TaskWrapper> contextTaskMap = new HashMap();

    @Inject
    public TaskEngine(ExecutorService executorService, TaskWrapperProvider taskExecutorFactory) {
        this.executorService = executorService;
        this.taskExecutorFactory = taskExecutorFactory;
    }

    public TaskInfo createTask(String submitter, TaskContext context, StorableTabularResource tabularResource) {
        OperationTaskInfo taskInfo = new OperationTaskInfo(submitter, tabularResource.getId());
        this.create((TaskInfo)taskInfo, context, tabularResource, null);
        return taskInfo;
    }

    public TaskInfo createTask(String submitter, TaskContext context, StorableTabularResource tabularResource, RunnableTask onSuccess) {
        OperationTaskInfo taskInfo = new OperationTaskInfo(submitter, tabularResource.getId());
        this.create((TaskInfo)taskInfo, context, tabularResource, onSuccess);
        return taskInfo;
    }

    public TaskInfo createRollbackTask(String submitter, TaskContext context, StorableTabularResource tabularResource, List<Long> historyStepToRemove) {
        RollbackTaskInfo taskInfo = new RollbackTaskInfo(submitter, tabularResource.getId(), historyStepToRemove);
        this.create((TaskInfo)taskInfo, context, tabularResource, null);
        return taskInfo;
    }

    public TaskInfo createTemplateTask(String submitter, TaskContext context, StorableTabularResource tabularResource, long templateId, RunnableTask onSuccess) {
        TemplateTaskInfo taskInfo = new TemplateTaskInfo(submitter, tabularResource.getId(), templateId);
        this.create((TaskInfo)taskInfo, context, tabularResource, onSuccess);
        return taskInfo;
    }

    private synchronized void create(TaskInfo taskInfo, TaskContext context, StorableTabularResource tabularResource, RunnableTask onSuccess) {
        StorableTask storableTask = new StorableTask(taskInfo, tabularResource);
        storableTask.setTaskContext(context);
        taskInfo.setTaskSteps(context.getTasks());
        storableTask.setStoredTask(taskInfo);
        this.logger.trace("task created : " + storableTask.getIdentifier());
        this.startTask(taskInfo.getIdentifier(), storableTask, tabularResource, context, onSuccess);
    }

    private void startTask(String taskId, StorableTask taskProxy, StorableTabularResource tabularResource, TaskContext context, RunnableTask onSuccess) {
        TaskWrapper task = this.taskExecutorFactory.get(context, tabularResource, taskProxy, false);
        if (onSuccess != null) {
            task.registerOnSuccessEvent(onSuccess);
        }
        contextTaskMap.put(taskId, task);
        this.executorService.execute(ScopedTasks.bind((Runnable)AuthorizedTasks.bind((Runnable)task)));
    }

    public TaskInfo get(String taskId, EntityManager entityManager) throws NoSuchTaskException {
        StorableTask task;
        if (contextTaskMap.containsKey(taskId)) {
            task = ((TaskWrapper)contextTaskMap.get(taskId)).getTask();
        } else {
            task = (StorableTask)entityManager.find(StorableTask.class, (Object)taskId);
            if (task == null) {
                throw new NoSuchTaskException(taskId);
            }
        }
        TaskInfo info = task.getStoredTask();
        info.setTaskSteps(task.getTaskContext().getTasks());
        if (contextTaskMap.containsKey(taskId) && (info.getStatus() == TaskStatus.ABORTED || info.getStatus() == TaskStatus.FAILED || info.getStatus() == TaskStatus.STOPPED || info.getStatus() == TaskStatus.SUCCEDED)) {
            contextTaskMap.remove(info.getIdentifier());
        }
        return info;
    }

    public TaskInfo continueTaskExecution(StorableTask task, Map<String, Object> instanceParametersToChange) throws NoSuchTaskException {
        TaskContext tContext = task.getTaskContext();
        tContext.resetPostOperationsForResume();
        tContext.cleanValidationsOnCurrentStep();
        tContext.movePrevious();
        if (instanceParametersToChange != null && !instanceParametersToChange.isEmpty()) {
            tContext.addParametersOnNextOperation(instanceParametersToChange);
        }
        TaskWrapper taskExecutor = this.taskExecutorFactory.get(tContext, task.getTabularResource(), task, true);
        contextTaskMap.put(task.getIdentifier(), taskExecutor);
        this.executorService.execute(ScopedTasks.bind((Runnable)taskExecutor));
        return task.getStoredTask();
    }

    public void abort(TaskInfo task, EntityManager em) throws NoSuchTaskException {
        if (task.getStatus() == TaskStatus.FAILED || task.getStatus() == TaskStatus.ABORTED || task.getStatus() == TaskStatus.SUCCEDED) {
            return;
        }
        if (contextTaskMap.containsKey(task.getIdentifier())) {
            TaskWrapper taskWrapper = (TaskWrapper)contextTaskMap.get(task.getIdentifier());
            task.setTaskSteps(taskWrapper.getTaskContext().getTasks());
            taskWrapper.abort();
        } else {
            em.getTransaction().begin();
            try {
                StorableTask stask = (StorableTask)em.find(StorableTask.class, (Object)task.getIdentifier());
                if (stask == null) {
                    throw new NoSuchTaskException(task.getIdentifier());
                }
                stask.getStoredTask().setStatus(TaskStatus.ABORTED);
                em.merge((Object)stask);
            }
            finally {
                em.getTransaction().commit();
            }
        }
    }

    public TaskInfo remove(String taskId, EntityManager em) throws NoSuchTaskException {
        StorableTask task = (StorableTask)em.find(StorableTask.class, (Object)taskId);
        if (task == null) {
            throw new NoSuchTaskException(taskId);
        }
        TaskInfo info = task.getStoredTask();
        this.abort(info, em);
        em.getTransaction().begin();
        em.remove((Object)task);
        em.getTransaction().commit();
        return info;
    }
}

