/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskStep;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.CountMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.task.TabularResourceDescriptor;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationContext;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationHandler;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.OperationWorkerCreator;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.WorkerCreator;
import org.gcube.data.analysis.tabulardata.task.executor.operation.listener.ExecutionListener;
import org.gcube.data.analysis.tabulardata.task.executor.operation.listener.PostOperationListener;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.gcube.data.analysis.tabulardata.utils.OperationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandler
implements ExecutionListener {
    private static Logger logger = LoggerFactory.getLogger(TaskHandler.class);
    private CubeManager cubeManager;
    private TaskContext context;
    private WorkerCreator workerCreator;
    private boolean stopped = false;
    private boolean aborted = false;
    private TabularResourceDescriptor descriptor;
    private OperationHandler opHandler;
    private OperationUtil opUtil;
    private DatabaseConnectionProvider connProvider;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$analysis$tabulardata$commons$webservice$types$OnRowErrorAction;

    public TaskHandler(CubeManager cubeManager, TaskContext context, WorkerCreator workerCreator, TabularResourceDescriptor descriptor, OperationUtil opUtil, DatabaseConnectionProvider connProvider) {
        this.cubeManager = cubeManager;
        this.context = context;
        this.workerCreator = workerCreator;
        this.descriptor = descriptor;
        this.opUtil = opUtil;
        this.connProvider = connProvider;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean run(ExecutionHolder executionHolder) throws WorkerException, OperationAbortedException {
        if (this.context.getCurrentTable() != null) {
            this.cubeManager.removeValidations(this.context.getCurrentTable());
        }
        while (!this.aborted && !this.stopped && this.context.hasNext()) {
            this.context.moveNext();
            OperationContext operationContext = this.createExecutionContext(this.context.getCurrentInvocation(), this.context.getCurrentTask());
            this.opHandler = new OperationHandler(operationContext, this.workerCreator, (ExecutionListener)this);
            TableId tableId = this.opHandler.run(executionHolder, this.context.getCurrentInvocation());
            this.context.setCurrentTable(tableId);
        }
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        this.cubeManager.modifyTableMeta(this.context.getCurrentTable()).setTableMetadata(new TableMetadata[]{new TableDescriptorMetadata(this.descriptor.getName(), this.descriptor.getVersion(), this.descriptor.getRefId())}).create();
        boolean valid = true;
        if (!this.context.isParallelizableExecution()) {
            valid = this.executePostValidations();
            this.executePostOperations();
        }
        this.setCountMetadata(this.context.getCurrentTable());
        return valid;
    }

    private void setCountMetadata(TableId currentTableId) {
        Table currentTable = this.cubeManager.getTable(currentTableId);
        if (!currentTable.contains(CountMetadata.class) && !currentTable.contains(DatasetViewTableMetadata.class)) {
            int count;
            try {
                count = SQLHelper.getCount((DatabaseConnectionProvider)this.connProvider, (String)currentTable.getName(), null);
            }
            catch (Exception e) {
                logger.error("error getting count for table with id {}", (Object)this.context.getCurrentTable().getValue());
                throw new RuntimeException(e);
            }
            this.cubeManager.modifyTableMeta(currentTableId).setTableMetadata(new TableMetadata[]{new CountMetadata(count)}).create();
        }
    }

    private void executePostOperations() throws WorkerException, OperationAbortedException {
        if (!this.context.getPostOperations().isEmpty()) {
            ExecutionHolder executionHolder = new ExecutionHolder();
            PostOperationListener listener = new PostOperationListener((ExecutionListener)this);
            OperationWorkerCreator operationWorkerCreator = new OperationWorkerCreator();
            int index = 0;
            while (index < this.context.getPostOperations().size()) {
                InternalInvocation invocation = (InternalInvocation)this.context.getPostOperations().get(index);
                OperationContext operationContext = this.createExecutionContext(invocation, (TaskStep)this.context.getPostOperationTasks().get(index));
                OperationHandler operationHandler = new OperationHandler(operationContext, (WorkerCreator)operationWorkerCreator, (ExecutionListener)listener);
                TableId tableId = operationHandler.run(executionHolder, invocation);
                this.context.setCurrentTable(tableId);
                ++index;
            }
        }
    }

    private boolean executePostValidations() throws WorkerException, OperationAbortedException {
        logger.trace("executing " + this.context.getPostValidations().size() + " post validations");
        if (!this.context.getPostValidations().isEmpty()) {
            ExecutionHolder executionHolder = new ExecutionHolder();
            PostOperationListener listener = new PostOperationListener((ExecutionListener)this);
            OperationWorkerCreator operationWorkerCreator = new OperationWorkerCreator();
            int index = 0;
            while (index < this.context.getPostValidations().size()) {
                InternalInvocation invocation = (InternalInvocation)this.context.getPostValidations().get(index);
                logger.trace("executing postValidation " + invocation.getWorkerFactory().getOperationDescriptor().getName());
                OperationContext operationContext = this.createExecutionContext(invocation, (TaskStep)this.context.getPostValidationTasks().get(index));
                OperationHandler operationHandler = new OperationHandler(operationContext, (WorkerCreator)operationWorkerCreator, (ExecutionListener)listener);
                operationHandler.run(executionHolder, invocation);
                ++index;
            }
            return listener.isValid();
        }
        return true;
    }

    private OperationContext createExecutionContext(InternalInvocation invocation, TaskStep step) {
        WorkerFactory factory = invocation.getWorkerFactory();
        OperationContext operationContext = new OperationContext(this.context.getCurrentTable(), this.context.getStartingTable(), factory, step, this.cubeManager);
        return operationContext;
    }

    /*
     * Exception decompiling
     */
    public boolean onStop(OperationContext opContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ColumnLocalId> getValidationColumnsForOperation(OperationContext opContext) {
        ArrayList<ColumnLocalId> columns = new ArrayList<ColumnLocalId>();
        for (ValidationDescriptor descriptor : opContext.getTaskStep().getValidations()) {
            if (descriptor.getValidationColumn() == null) continue;
            columns.add(new ColumnLocalId(descriptor.getValidationColumn()));
        }
        return columns;
    }

    public void abort() {
        if (this.opHandler != null) {
            this.opHandler.getWorkerExecutor().abort();
        }
        this.aborted = true;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$analysis$tabulardata$commons$webservice$types$OnRowErrorAction() {
        if ($SWITCH_TABLE$org$gcube$data$analysis$tabulardata$commons$webservice$types$OnRowErrorAction != null) {
            return $SWITCH_TABLE$org$gcube$data$analysis$tabulardata$commons$webservice$types$OnRowErrorAction;
        }
        int[] nArray = new int[OnRowErrorAction.values().length];
        try {
            nArray[OnRowErrorAction.ASK.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OnRowErrorAction.DISCARD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OnRowErrorAction.SAVE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$analysis$tabulardata$commons$webservice$types$OnRowErrorAction = nArray;
        return nArray;
    }
}

