/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor.operation;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.Result;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ColumnCreatorWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationContext;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.WorkerCreator;
import org.gcube.data.analysis.tabulardata.task.executor.operation.listener.ExecutionListener;
import org.gcube.data.analysis.tabulardata.task.executor.workers.WorkerExecutor;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationHandler {
    private static final Logger log = LoggerFactory.getLogger(OperationHandler.class);
    private static Logger logger = LoggerFactory.getLogger(OperationHandler.class);
    private WorkerExecutor workerExecutor;
    private OperationContext operationContext;
    private WorkerCreator workerCreator;
    private ExecutionListener listener;

    public OperationHandler(OperationContext operationContext, WorkerCreator workerCreator, ExecutionListener listener) {
        this.workerExecutor = new WorkerExecutor(operationContext);
        this.operationContext = operationContext;
        this.workerCreator = workerCreator;
        this.listener = listener;
    }

    public TableId run(ExecutionHolder executionHolder, InternalInvocation invocation) throws WorkerException, OperationAbortedException {
        List preconditions;
        Worker worker;
        try {
            worker = this.workerCreator.getWorker(invocation, this.operationContext, executionHolder);
        }
        catch (InvalidInvocationException iie) {
            throw new WorkerException("error invoking worker : " + iie.getMessage(), (Throwable)iie);
        }
        try {
            preconditions = this.workerCreator.getPreconditions(invocation, this.operationContext, executionHolder);
        }
        catch (Exception iie) {
            throw new WorkerException("error invoking preconditions : " + iie.getMessage(), (Throwable)iie);
        }
        if (!preconditions.isEmpty()) {
            this.workerExecutor.executeValidations(preconditions);
            logger.trace("precondition result " + this.operationContext.getPreconditionResult());
            this.operationContext.getTaskStep().addValidations(this.operationContext.getPreconditionResult().getValidations());
            if (!this.operationContext.getPreconditionResult().isValid() && !this.listener.onStop(this.operationContext)) {
                return this.operationContext.getCurrentTableId();
            }
        }
        Result result = this.workerExecutor.executeOperation(worker);
        if (worker instanceof ColumnCreatorWorker) {
            List createdColumns = ((ColumnCreatorWorker)worker).getCreatedColumns();
            int index = 0;
            for (ColumnLocalId columnId : createdColumns) {
                String columnInvocationId = InternalInvocation.getDinamicallyCreatedColumnId((String)invocation.getInvocationId(), (int)index++);
                log.debug("ADDING column " + columnInvocationId + " associated with " + columnId.getValue());
                executionHolder.addColumnCreatedMapping(columnInvocationId, columnId);
            }
        } else if (worker instanceof ValidationWorker) {
            this.operationContext.getTaskStep().addValidations(WorkerExecutor.getValidationDescriptions((ValidityResult)((ValidityResult)result)));
            logger.trace(String.valueOf(worker.getClass().getSimpleName()) + " has resulted valid? " + ((ValidityResult)result).isValid());
            if (!((ValidityResult)result).isValid() && !this.listener.onStop(this.operationContext)) {
                return this.operationContext.getCurrentTableId();
            }
        }
        return this.workerCreator.resultCollector(executionHolder, result, this.operationContext, worker.getSourceInvocation());
    }

    public WorkerExecutor getWorkerExecutor() {
        return this.workerExecutor;
    }
}

