/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata.tabularresource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.metadata.Identifiable;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.metadata.notification.StorableNotification;
import org.gcube.data.analysis.tabulardata.metadata.resources.StorableResource;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.EditEntry;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RelationLink;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RuleMapping;
import org.gcube.data.analysis.tabulardata.metadata.task.StorableTask;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;

@NamedQueries(value={@NamedQuery(name="TR.getAll", query="SELECT DISTINCT str FROM StorableTabularResource str LEFT JOIN str.sharedWith s WHERE  ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes and str.hidden=false and str.deleted=false ORDER BY str.creationDate DESC"), @NamedQuery(name="TR.getAllByType", query="SELECT DISTINCT str FROM StorableTabularResource str LEFT JOIN str.sharedWith s WHERE  ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes and str.tableType =:type and str.hidden=false and str.deleted=false ORDER BY str.creationDate DESC"), @NamedQuery(name="TR.getById", query="SELECT DISTINCT str FROM StorableTabularResource str LEFT JOIN str.sharedWith s WHERE  str.id = :id and ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes and str.hidden=false and str.deleted=false"), @NamedQuery(name="TR.getByIdWithoutAuth", query="SELECT DISTINCT str FROM StorableTabularResource str WHERE  str.id = :id and str.hidden=false and str.deleted=false"), @NamedQuery(name="TR.getAllWithoutAuth", query="SELECT DISTINCT str FROM StorableTabularResource str WHERE  str.hidden=false and str.deleted=false")})
@Entity
public class StorableTabularResource
implements Serializable,
Identifiable {
    private static final long serialVersionUID = 1L;
    private static String GENERIC_TYPE_NAME = new GenericTableType().getName();
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected long id;
    @Column
    private Long tableId = null;
    @Column
    private boolean hidden = false;
    @Column
    private boolean deleted = false;
    @Column
    private boolean locked = false;
    @Column
    private TabularResourceType tabularResourceType = TabularResourceType.STANDARD;
    @Column
    private String tableType = GENERIC_TYPE_NAME;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate = Calendar.getInstance();
    @Column(nullable=false)
    private String owner;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<RuleMapping> rules = new ArrayList();
    @Column
    private boolean finalized = false;
    @Column
    private String name;
    @Column
    private String tabularResourceVersion = "0.0.1-0";
    @Column
    private boolean valid = true;
    @Column(nullable=false)
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    private List<String> sharedWith = new ArrayList();
    @Lob
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(joinColumns={@JoinColumn(name="prop_id")})
    private Map<String, Serializable> properties = new HashMap();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="date ASC")
    private List<StorableHistoryStep> historySteps = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL})
    @OrderBy(value="startTime DESC")
    private List<StorableTask> tasks = new ArrayList();
    @ElementCollection(targetClass=String.class)
    private List<String> scopes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="linkedTabularResource")
    private List<RelationLink> linkedBy = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="linksTotabularResource")
    private List<RelationLink> linksTo = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<EditEntry> editEntries = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<StorableNotification> notifications = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<StorableResource> resources = new ArrayList();
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST})
    private StorableTabularResource newVersion = null;
    @OneToOne(mappedBy="newVersion", cascade={CascadeType.MERGE, CascadeType.PERSIST})
    private StorableTabularResource oldVersion = null;

    public StorableTabularResource() {
    }

    public StorableTabularResource(TabularResourceType tabularResourceType, String owner, String name, List<StorableHistoryStep> historySteps, List<StorableTask> tasks, List<String> scopes) {
        this.name = name;
        this.owner = owner;
        this.historySteps = historySteps;
        this.tasks = tasks;
        this.scopes = scopes;
        this.tabularResourceType = tabularResourceType;
    }

    public StorableTabularResource(TabularResourceType tabularResourceType, String owner, String name, String scope) {
        this.name = name;
        this.owner = owner;
        this.scopes.add(scope);
        this.tabularResourceType = tabularResourceType;
    }

    public long getId() {
        return this.id;
    }

    public List<StorableHistoryStep> getHistorySteps() {
        return Collections.unmodifiableList(this.historySteps);
    }

    public void removeHistoryStep(StorableHistoryStep step) {
        this.historySteps.remove(step);
    }

    public void addHistorySteps(List<StorableHistoryStep> steps) {
        this.historySteps.addAll(steps);
    }

    public void addHistoryStep(StorableHistoryStep step) {
        this.historySteps.add(step);
    }

    public void setHistorySteps(LinkedList<StorableHistoryStep> historySteps) {
        this.historySteps = historySteps;
    }

    public List<StorableTask> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public void addTask(StorableTask task) {
        this.tasks.add(task);
    }

    public void setTasks(List<StorableTask> tasks) {
        this.tasks = tasks;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(List<String> sharedWith) {
        this.sharedWith = sharedWith;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TabularResourceType getTabularResourceType() {
        return this.tabularResourceType;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    public void addRule(RuleMapping rule) {
        this.rules.add(rule);
    }

    public void addRules(List<RuleMapping> rules) {
        this.rules.addAll(rules);
    }

    public StorableTabularResource getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(StorableTabularResource newVersion) {
        this.newVersion = newVersion;
    }

    public StorableTabularResource getOldVersion() {
        return this.oldVersion;
    }

    public List<StorableNotification> getNotifications() {
        return this.notifications;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<EditEntry> getEditEntries() {
        return Collections.unmodifiableList(this.editEntries);
    }

    public void addEditEntries(EditEntry editEntry) {
        this.editEntries.add(editEntry);
    }

    public String getVersion() {
        return this.tabularResourceVersion;
    }

    public RuleMapping removeColumnRuleMapping(long id, String columnLocalId) {
        int index = -1;
        int i = 0;
        while (i < this.rules.size()) {
            if (((RuleMapping)this.rules.get(i)).getStorableRule().getId() == id && ((RuleMapping)this.rules.get(i)).getColumnLocalId().equals(columnLocalId)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return (RuleMapping)this.rules.remove(index);
        }
        return null;
    }

    public RuleMapping removeTableRuleMapping(long id) {
        int index = -1;
        int i = 0;
        while (i < this.rules.size()) {
            if (((RuleMapping)this.rules.get(i)).getStorableRule().getId() == id) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return (RuleMapping)this.rules.remove(index);
        }
        return null;
    }

    public void removeAllRules() {
        this.rules = new ArrayList();
    }

    public List<RuleMapping> getRules() {
        return this.rules;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public List<RelationLink> getLinkedBy() {
        return this.linkedBy;
    }

    public void setLinkedBy(List<RelationLink> linkedBy) {
        this.linkedBy = linkedBy;
    }

    public List<RelationLink> getLinksTo() {
        return this.linksTo;
    }

    public void setLinksTo(List<RelationLink> linksTo) {
        this.linksTo = linksTo;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void addResource(StorableResource resource) {
        this.resources.add(resource);
    }

    public void removeResource(StorableResource resource) {
        this.resources.remove(resource);
    }

    public List<StorableResource> getResources() {
        return this.resources;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void finalize(boolean finalize) {
        this.finalized = finalize;
    }

    public void setTabularResourceType(TabularResourceType tabularResourceType) {
        this.tabularResourceType = tabularResourceType;
    }

    public String toString() {
        return "StorableTabularResource [id=" + this.id + ", owner = " + this.owner + ", locked=" + this.locked + ", historySteps=" + this.historySteps + ", scopes=" + this.scopes + ", sharedWith= " + this.sharedWith + " ]";
    }
}

