/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor.operation.creators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.Result;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationContext;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.WorkerCreator;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationWorkerCreator
extends WorkerCreator {
    private static final Logger log = LoggerFactory.getLogger(OperationWorkerCreator.class);

    protected Worker<?> create(InternalInvocation invocation, OperationContext operationContext, ExecutionHolder executionHolder) throws InvalidInvocationException {
        OperationInvocation operationInvocation = this.createInvocation(invocation.getWorkerFactory(), invocation, operationContext.getCurrentTableId(), operationContext.getReferredTableId(), executionHolder);
        logger.trace("creating worker " + invocation.getWorkerFactory().getOperationDescriptor().getName() + " with parameters " + operationInvocation.getParameterInstances().toString());
        return invocation.getWorkerFactory().createWorker(operationInvocation);
    }

    protected List<ValidationWorker> discoveryPreconditions(InternalInvocation invocation, OperationContext operationContext, ExecutionHolder executionHolder) throws Exception {
        ArrayList<ValidationWorker> preconditionWorkers = new ArrayList<ValidationWorker>();
        for (Map.Entry entry : invocation.getWorkerFactory().getPreconditionValidationMap().entrySet()) {
            invocation.setParameters(invocation.getWorkerFactory().getParametersForPrecondion((String)entry.getKey(), operationContext.getCurrentTableId(), invocation.getColumnId(), invocation.getParameters()));
            OperationInvocation operationInvocation = this.createInvocation((WorkerFactory)entry.getValue(), invocation, operationContext.getCurrentTableId(), operationContext.getReferredTableId(), executionHolder);
            preconditionWorkers.add((ValidationWorker)((WorkerFactory)entry.getValue()).createWorker(operationInvocation));
        }
        return preconditionWorkers;
    }

    public TableId resultCollector(ExecutionHolder executionHolder, Result result, OperationContext operationContext, OperationInvocation sourceInvocation) {
        if (result instanceof ResourcesResult) {
            ResourcesResult resourcesResult = (ResourcesResult)result;
            for (ResourceDescriptorResult resourceResult : resourcesResult.getResources()) {
                executionHolder.addCreatedResource(new ExecutionHolder.ResourceHolder(resourceResult, operationContext.getWorkerFactory().getOperationDescriptor().getOperationId().getValue()));
            }
        } else if (result instanceof WorkerResult) {
            WorkerResult workerResult = (WorkerResult)result;
            executionHolder.createStep(operationContext.getWorkerFactory(), sourceInvocation, workerResult, operationContext.getCurrentTableId());
            if (operationContext.getWorkerFactory().isRollbackable()) {
                executionHolder.removeOnFinish(operationContext.getCurrentTableId());
            }
            return workerResult.getResultTable().getId();
        }
        return operationContext.getCurrentTableId();
    }

    protected OperationInvocation createInvocation(WorkerFactory<?> factory, InternalInvocation invocation, TableId currentTableId, TableId referredTableId, ExecutionHolder executionHolder) throws InvalidInvocationException {
        InvocationCreator invocationCreator = InvocationCreator.getCreator((OperationDescriptor)factory.getOperationDescriptor());
        if (referredTableId != null) {
            invocationCreator.setToUpdateReferredTable(referredTableId);
        }
        if (invocation.getParameters() != null) {
            Map parameters = invocation.getParameters();
            if (executionHolder.areNewColumnsBeenCreated()) {
                parameters = this.updateParameters(parameters, executionHolder, referredTableId);
            }
            invocationCreator.setParameters(parameters);
        }
        if (currentTableId != null) {
            invocationCreator.setTargetTable(currentTableId);
        }
        if (invocation.getColumnId() != null) {
            log.debug("CHECKING for column correspondance " + invocation.getColumnId());
            if (executionHolder.getColumnCorrespondance(invocation.getColumnId().getValue()) != null) {
                invocationCreator.setTargetColumn(executionHolder.getColumnCorrespondance(invocation.getColumnId().getValue()));
            } else {
                invocationCreator.setTargetColumn(invocation.getColumnId());
            }
        }
        return invocationCreator.create();
    }

    private Map<String, Object> updateParameters(Map<String, Object> parameters, ExecutionHolder executionHolder, TableId referredTableId) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            toReturn.put(entry.getKey(), this.updateSingleParameter(entry.getValue(), executionHolder, referredTableId));
        }
        return toReturn;
    }

    private Object updateSingleParameter(Object object, ExecutionHolder executionHolder, TableId referredTableId) {
        if (object instanceof ColumnReference) {
            ColumnReference colRef = (ColumnReference)object;
            ColumnLocalId newId = executionHolder.getColumnCorrespondance(colRef.getColumnId().getValue());
            if (newId != null && colRef.getTableId().equals((Object)referredTableId)) {
                return new ColumnReference(referredTableId, newId, colRef.getType());
            }
            return colRef;
        }
        if (object instanceof Expression) {
            for (Expression subExpression : ((Expression)object).getLeavesByType(ColumnReference.class)) {
                ColumnReference reference = (ColumnReference)subExpression;
                ColumnLocalId newId = executionHolder.getColumnCorrespondance(reference.getColumnId().getValue());
                if (newId == null || !reference.getTableId().equals((Object)referredTableId)) continue;
                ((ColumnReference)subExpression).setColumnId(newId);
            }
            return object;
        }
        if (object instanceof Map) {
            return this.updateParameters((Map)object, executionHolder, referredTableId);
        }
        if (object instanceof List) {
            ArrayList<Object> toReturn = new ArrayList<Object>();
            for (Object obj : (List)object) {
                toReturn.add(this.updateSingleParameter(obj, executionHolder, referredTableId));
            }
            return toReturn;
        }
        return object;
    }
}

