package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class BaseColumnFactory {
	
	protected static Column create(ColumnType columnType, String name, LocalizedText label, DataType dataType){
		Column result = create(columnType, label, dataType);
		result.setName(name);
		return result;
	}
	
	protected static Column create(ColumnType columnType, LocalizedText label, DataType dataType){
		Column result = new Column(generateColumnId(),dataType,columnType);
		result.setColumnType(columnType);
		result.setDataType(dataType);
		
		NamesMetadata labelsMetadata = null;
		try {
			labelsMetadata = result.getMetadata(NamesMetadata.class);
		} catch (NoSuchMetadataException e) {
			List<LocalizedText> texts = new ArrayList<LocalizedText>();
			texts.add(label);
			labelsMetadata = new NamesMetadata(texts);
		}
		result.setMetadata(labelsMetadata);
		
		return result;
	}
	
	private static ColumnLocalId generateColumnId() {
		return new ColumnLocalId(UUID.randomUUID().toString());
	}

	protected static Column create(ColumnType columnType, DataType dataType){
		return new Column(generateColumnId(),dataType,columnType);
	}

}
