package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class CodeColumnFactory extends BaseColumnFactory{
	
	public static Column create(){
		Column codeColumn = create(new CodeColumnType(), new TextType(16));
		List<LocalizedText> texts = new ArrayList<LocalizedText>();
		texts.add(new ImmutableLocalizedText("Code"));
		NamesMetadata labelsMetadata = new NamesMetadata(texts);
		codeColumn.setMetadata(labelsMetadata);	
		return codeColumn;
	}

}
