package org.gcube.data.analysis.tabulardata.model.column.factories;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

public class TimeDimensionColumnFactory extends BaseColumnFactory {
	
	public static Column create(PeriodType periodType){
		return create(new TimeDimensionColumnType(), new ImmutableLocalizedText(periodType.getName()), new IntegerType());
	}

}
