/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column;

import com.google.common.base.Optional;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Integer;
import org.gcube.data.analysis.tabulardata.model.reference.TableReference;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationshipImpl;

public class CodelistRefColumn
extends Column {
    private String label;
    private Optional<String> name = Optional.absent();
    private ColumnRelationship columnRelationship;
    private static final long serialVersionUID = -357186049063007166L;

    public CodelistRefColumn(String label, ColumnRelationship relationship) {
        this.label = label;
        this.columnRelationship = relationship;
    }

    public CodelistRefColumn(String label, String name, ColumnRelationship relationship) {
        this.label = label;
        this.name = Optional.of((Object)name);
        this.columnRelationship = relationship;
    }

    public CodelistRefColumn(String label, TableReference codelistReference) {
        this.label = label;
        this.columnRelationship = new ColumnRelationshipImpl(codelistReference);
    }

    public CodelistRefColumn(String label, String name, TableReference codelistReference) {
        this.label = label;
        this.name = Optional.of((Object)name);
        this.columnRelationship = new ColumnRelationshipImpl(codelistReference);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.CODELISTREF;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean hasName() {
        return this.name.isPresent();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public void setName(String name) {
        this.name = Optional.of((Object)name);
    }

    @Override
    public DataType getDataType() {
        return new Integer();
    }

    @Override
    public boolean hasRelationship() {
        return true;
    }

    @Override
    public ColumnRelationship getRelationship() {
        return this.columnRelationship;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnRelationship == null ? 0 : this.columnRelationship.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodelistRefColumn other = (CodelistRefColumn)obj;
        if (this.columnRelationship == null ? other.columnRelationship != null : !this.columnRelationship.equals(other.columnRelationship)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

