package org.gcube.data.analysis.tabulardata.model.column;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Integer;
import org.gcube.data.analysis.tabulardata.model.reference.TableReference;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationshipImpl;

import com.google.common.base.Optional;

public class CodelistRefColumn extends Column {

	private String label;

	private Optional<String> name = Optional.absent();

	private ColumnRelationship columnRelationship;

	/**
	 * 
	 */
	private static final long serialVersionUID = -357186049063007166L;

	/**
	 * Creates a {@link CodelistRefColumn} with the given relationship.
	 * @param label
	 * @param relationship
	 */
	public CodelistRefColumn(String label, ColumnRelationship relationship) {
		this.label = label;
		this.columnRelationship = relationship;
	}
	/**
	 * Creates named {@link CodelistRefColumn} with the given relationship.
	 * @param label
	 * @param name
	 * @param relationship
	 */
	public CodelistRefColumn(String label, String name, ColumnRelationship relationship) {
		this.label = label;
		this.name = Optional.of(name);
		this.columnRelationship = relationship;
	}
	/**
	 * Creates a {@link CodelistRefColumn} with a relationship pointing to the ID column of the target codelist.
	 * @param label
	 * @param codelistReference
	 */
	public CodelistRefColumn(String label, TableReference codelistReference) {
		this.label = label;
		this.columnRelationship = new ColumnRelationshipImpl(codelistReference);
	}
	/**
	 * Creates a named {@link CodelistRefColumn} with a relationship pointing to the ID column of the target codelist.
	 * @param label
	 * @param name
	 * @param codelistReference
	 */
	public CodelistRefColumn(String label, String name, TableReference codelistReference) {
		this.label = label;
		this.name = Optional.of(name);
		this.columnRelationship = new ColumnRelationshipImpl(codelistReference);
	}

	@Override
	public ColumnType getColumnType() {
		return ColumnType.CODELISTREF;
	}

	@Override
	public String getLabel() {
		return label;
	}

	@Override
	public void setLabel(String label) {
		this.label=label;
	}

	@Override
	public boolean hasName() {
		return name.isPresent();
	}

	@Override
	public String getName() {
		return name.get();
	}

	@Override
	public void setName(String name) {
		this.name = Optional.of(name);
	}

	@Override
	public DataType getDataType() {
		return new Integer();
	}

	@Override
	public boolean hasRelationship() {
		return true;
	}

	@Override
	public ColumnRelationship getRelationship() {
		return columnRelationship;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((columnRelationship == null) ? 0 : columnRelationship.hashCode());
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CodelistRefColumn other = (CodelistRefColumn) obj;
		if (columnRelationship == null) {
			if (other.columnRelationship != null)
				return false;
		} else if (!columnRelationship.equals(other.columnRelationship))
			return false;
		if (label == null) {
			if (other.label != null)
				return false;
		} else if (!label.equals(other.label))
			return false;
		return true;
	}

}
