/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column;

import com.google.common.base.Optional;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Text;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

public class CodeColumn
extends Column {
    String label;
    Optional<String> name = Optional.absent();
    private static final long serialVersionUID = -2455259282821299431L;

    public CodeColumn(String label) {
        this.label = label;
    }

    public CodeColumn(String label, String name) {
        this.label = label;
        this.name = Optional.of((Object)name);
    }

    public CodeColumn(CodeColumn column) {
        this(column.getLabel(), column.getName());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean hasName() {
        return this.name.isPresent();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public DataType getDataType() {
        return new Text();
    }

    @Override
    public boolean hasRelationship() {
        return false;
    }

    @Override
    public ColumnRelationship getRelationship() {
        throw new IllegalStateException("Columns of type " + (Object)((Object)this.getColumnType()) + " do not support relationships");
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.CODE;
    }

    @Override
    public void setName(String name) {
        this.name = Optional.of((Object)name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeColumn other = (CodeColumn)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

