/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column;

import com.google.common.base.Optional;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

public class MeasureColumn
extends Column {
    private String label;
    private Optional<String> name = Optional.absent();
    private DataType dataType;
    private static final long serialVersionUID = 2619071400270013354L;

    public MeasureColumn(String label, DataType dataType) {
        this.label = label;
        this.dataType = dataType;
    }

    public MeasureColumn(String label, String name, DataType dataType) {
        this(label, dataType);
        this.name = Optional.of((Object)name);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.MEASURE;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean hasName() {
        return this.name.isPresent();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean hasRelationship() {
        return false;
    }

    @Override
    public ColumnRelationship getRelationship() {
        throw new IllegalStateException("Columns of type " + (Object)((Object)this.getColumnType()) + " do not support relationships");
    }

    @Override
    public void setName(String name) {
        this.name = Optional.of((Object)name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeasureColumn other = (MeasureColumn)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

