/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataTypeEnum;
import org.gcube.data.analysis.tabulardata.model.datatype.geometry.GeometryType;

public class Geometry
implements DataType {
    private static final long serialVersionUID = 522898962047621730L;
    private int srid = -1;
    private GeometryType type;
    private int dimensions;

    public Geometry(int srid, int dimensions) {
        this.srid = srid;
        this.type = GeometryType.GEOMETRY;
        this.dimensions = dimensions;
    }

    public Geometry(int dimensions) {
        this.type = GeometryType.GEOMETRY;
        this.dimensions = dimensions;
    }

    public Geometry(int srid, GeometryType type, int dimensions) {
        this.srid = srid;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = type;
        this.dimensions = dimensions;
    }

    public Geometry(GeometryType type, int dimensions) {
        this.type = type;
        this.dimensions = dimensions;
    }

    @Override
    public DataTypeEnum getDataType() {
        return DataTypeEnum.GEOMETRY;
    }

    public int getSrid() {
        return this.srid;
    }

    public GeometryType getGeometryType() {
        return this.type;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensions;
        result = 31 * result + this.srid;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Geometry other = (Geometry)obj;
        if (this.dimensions != other.dimensions) {
            return false;
        }
        if (this.srid != other.srid) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Geometry(");
        builder.append(this.srid);
        builder.append(",");
        builder.append((Object)this.type);
        builder.append(",");
        builder.append(this.dimensions);
        builder.append(")");
        return builder.toString();
    }
}

