package org.gcube.data.analysis.tabulardata.model.column;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Text;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

import com.google.common.base.Optional;

/**
 * Represent a column containing the unique codes of the codelist.
 * 
 * @author "Luigi Fortunati"
 * 
 */
public class CodeColumn extends Column {

	String label;

	Optional<String> name = Optional.absent();

	/**
	 * 
	 */
	private static final long serialVersionUID = -2455259282821299431L;

	public CodeColumn(String label) {
		this.label = label;
	}

	public CodeColumn(String label, String name) {
		this.label = label;
		this.name = Optional.of(name);
	}

	public CodeColumn(CodeColumn column) {
		this(column.getLabel(), column.getName());
	}

	@Override
	public String getLabel() {
		return label;
	}

	@Override
	public void setLabel(String label) {
		this.label=label;
	}

	@Override
	public boolean hasName() {
		return name.isPresent();
	}

	@Override
	public String getName() {
		return name.get();
	}

	@Override
	public DataType getDataType() {
		return new Text();
	}

	@Override
	public boolean hasRelationship() {
		return false;
	}

	@Override
	public ColumnRelationship getRelationship() {
		throw new IllegalStateException("Columns of type " + getColumnType() + " do not support relationships");
	}

	@Override
	public ColumnType getColumnType() {
		return ColumnType.CODE;
	}

	@Override
	public void setName(String name) {
		this.name = Optional.of(name);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CodeColumn other = (CodeColumn) obj;
		if (label == null) {
			if (other.label != null)
				return false;
		} else if (!label.equals(other.label))
			return false;
		return true;
	}

}
