package org.gcube.data.analysis.tabulardata.model.datatype;


public class Text implements DataType{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3012818814370962508L;
	
	private int lenght;
	
	/**
	 * Creates a Text data type with a maximum lenght of 256 characters
	 */
	public Text() {
		lenght = 256;
	}
	
	/**
	 * Creates a Text data type with a given maximum lenght
	 * @param lenght the number of allowed maximum characters
	 */
	public Text(int lenght) {
		super();
		this.lenght = lenght;
	}

	public int getLenght() {
		return lenght;
	}

	public DataTypeEnum getDataType() {
		return DataTypeEnum.TEXT;
	}
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + lenght;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Text other = (Text) obj;
		if (lenght != other.lenght)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Text [lenght=");
		builder.append(lenght);
		builder.append("]");
		return builder.toString();
	}

}
