package org.gcube.data.analysis.tabulardata.model.relationship;

import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.reference.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.reference.ColumnReferenceImpl;
import org.gcube.data.analysis.tabulardata.model.reference.TableReference;

public class ColumnRelationshipImpl implements ColumnRelationship {

	private static final long serialVersionUID = -170595322344282579L;
	
	private boolean childParent = true;
	
	private	ColumnReference targetTablePrimaryKeyColumnRef;
	
	public ColumnRelationshipImpl(TableReference targetTableRef, boolean isChildParent) {
		super();
		this.childParent = isChildParent;
		this.targetTablePrimaryKeyColumnRef =new ColumnReferenceImpl(targetTableRef, IdColumn.COLUMN_NAME);
	}
	
	public ColumnRelationshipImpl(TableReference targetTableRef) {
		super();
		this.targetTablePrimaryKeyColumnRef =new ColumnReferenceImpl(targetTableRef, IdColumn.COLUMN_NAME);
	}
	
	public ColumnRelationshipImpl(ColumnReference targetPKRef, boolean isChildParent) {
		super();
		this.childParent = isChildParent;
		this.targetTablePrimaryKeyColumnRef = targetPKRef;
	}
	
	public ColumnRelationshipImpl(ColumnReference targetPKRef) {
		super();
		this.targetTablePrimaryKeyColumnRef = targetPKRef;
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.td.cube.model.relationship.ColumnRelationship#isChildParentRelationship()
	 */
	@Override
	public boolean isChildParentRelationship(){
		return childParent;
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.td.cube.model.relationship.ColumnRelationship#getTargetTableReference()
	 */
	@Override
	public TableReference getTargetTableRef(){
		return targetTablePrimaryKeyColumnRef;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.data.td.cube.model.relationship.ColumnRelationship#getTargetTablePrimaryKeyColumnReference()
	 */
	@Override
	public ColumnReference getTargetPKRef(){
		return targetTablePrimaryKeyColumnRef;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ColumnRelationshipImpl [childParent=");
		builder.append(childParent);
		builder.append(", targetTablePrimaryKeyColumnRef=");
		builder.append(targetTablePrimaryKeyColumnRef);
		builder.append("]");
		return builder.toString();
	}
	
	
	
}
