package org.gcube.data.analysis.tabulardata.model.table;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.AttributeColumn;
import org.gcube.data.analysis.tabulardata.model.column.CodeColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

/**
 * Represent a codelist. A codelist is a table made of one {@link IdColumn}, one
 * {@link CodeColumn}, one or more {@link AttributeColumn};
 * 
 * @author "Luigi Fortunati"
 * 
 */
public class Codelist extends Table {
	
	private List<Column> columns;

	public Codelist(Codelist codelist) {
		super(codelist.getId(), codelist.getName());
		columns = Lists.newArrayList(codelist.getColumns());
	}
	
	public Codelist(String name, Collection<Column> columns){
		super(name);
		this.columns = Lists.newArrayList(columns);
	}

	public Codelist(long id, String name, Collection<Column> columns) {
		super(id, name);
		this.columns = Lists.newArrayList(columns);
	}

	@Override
	public List<Column> getColumns() {
		return ImmutableList.copyOf(columns);
	}

	@Override
	public TableType getTableType() {
		return TableType.CODELIST;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((columns == null) ? 0 : columns.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		Codelist other = (Codelist) obj;
		if (columns == null) {
			if (other.columns != null)
				return false;
		} else if (!columns.equals(other.columns))
			return false;
		return true;
	}

}
